// Generated by rstantools.  Do not edit by hand.

/*
    MetaStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MetaStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MetaStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_MBMA_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_MBMA");
    reader.add_event(252, 250, "end", "model_MBMA");
    return reader;
}
#include <stan_meta_header.hpp>
class model_MBMA
  : public stan::model::model_base_crtp<model_MBMA> {
private:
        int Nobs;
        int Nst;
        std::vector<int> st;
        std::vector<double> dose;
        std::vector<int> ndose;
        int link;
        int dose_response;
        vector_d y;
        vector_d y_se;
        std::vector<int> r;
        std::vector<int> n;
        std::vector<int> count;
        vector_d exposure;
        vector_d mu_prior;
        vector_d alpha_prior;
        vector_d ED50_prior;
        double tau_prior;
        int tau_prior_dist;
        int ED50_prior_dist;
        vector_d gamma_prior;
        int Npred;
        std::vector<double> Pred_doses;
        std::vector<int> b_ndx;
        std::vector<int> t_ndx;
        int re;
        int ncp;
        int emax;
        int hill;
        double maxdose;
public:
    model_MBMA(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_MBMA(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_MBMA_namespace::model_MBMA";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "Nobs", "int", context__.to_vec());
            Nobs = int(0);
            vals_i__ = context__.vals_i("Nobs");
            pos__ = 0;
            Nobs = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nobs", Nobs, 1);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "Nst", "int", context__.to_vec());
            Nst = int(0);
            vals_i__ = context__.vals_i("Nst");
            pos__ = 0;
            Nst = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nst", Nst, 1);
            current_statement_begin__ = 15;
            validate_non_negative_index("st", "Nobs", Nobs);
            context__.validate_dims("data initialization", "st", "int", context__.to_vec(Nobs));
            st = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("st");
            pos__ = 0;
            size_t st_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < st_k_0_max__; ++k_0__) {
                st[k_0__] = vals_i__[pos__++];
            }
            size_t st_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < st_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "st[i_0__]", st[i_0__], 1);
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("dose", "Nobs", Nobs);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(Nobs));
            dose = std::vector<double>(Nobs, double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < dose_k_0_max__; ++k_0__) {
                dose[k_0__] = vals_r__[pos__++];
            }
            size_t dose_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < dose_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "dose[i_0__]", dose[i_0__], 0);
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("ndose", "Nst", Nst);
            context__.validate_dims("data initialization", "ndose", "int", context__.to_vec(Nst));
            ndose = std::vector<int>(Nst, int(0));
            vals_i__ = context__.vals_i("ndose");
            pos__ = 0;
            size_t ndose_k_0_max__ = Nst;
            for (size_t k_0__ = 0; k_0__ < ndose_k_0_max__; ++k_0__) {
                ndose[k_0__] = vals_i__[pos__++];
            }
            size_t ndose_i_0_max__ = Nst;
            for (size_t i_0__ = 0; i_0__ < ndose_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ndose[i_0__]", ndose[i_0__], 1);
            }
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            check_less_or_equal(function__, "link", link, 3);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "dose_response", "int", context__.to_vec());
            dose_response = int(0);
            vals_i__ = context__.vals_i("dose_response");
            pos__ = 0;
            dose_response = vals_i__[pos__++];
            check_greater_or_equal(function__, "dose_response", dose_response, 1);
            check_less_or_equal(function__, "dose_response", dose_response, 4);
            current_statement_begin__ = 31;
            validate_non_negative_index("y", "Nobs", Nobs);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(Nobs));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 32;
            validate_non_negative_index("y_se", "Nobs", Nobs);
            context__.validate_dims("data initialization", "y_se", "vector_d", context__.to_vec(Nobs));
            y_se = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("y_se");
            pos__ = 0;
            size_t y_se_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < y_se_j_1_max__; ++j_1__) {
                y_se(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 35;
            validate_non_negative_index("r", "Nobs", Nobs);
            context__.validate_dims("data initialization", "r", "int", context__.to_vec(Nobs));
            r = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("r");
            pos__ = 0;
            size_t r_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                r[k_0__] = vals_i__[pos__++];
            }
            size_t r_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "r[i_0__]", r[i_0__], 0);
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("n", "Nobs", Nobs);
            context__.validate_dims("data initialization", "n", "int", context__.to_vec(Nobs));
            n = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            size_t n_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < n_k_0_max__; ++k_0__) {
                n[k_0__] = vals_i__[pos__++];
            }
            size_t n_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n[i_0__]", n[i_0__], 1);
            }
            current_statement_begin__ = 39;
            validate_non_negative_index("count", "Nobs", Nobs);
            context__.validate_dims("data initialization", "count", "int", context__.to_vec(Nobs));
            count = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("count");
            pos__ = 0;
            size_t count_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < count_k_0_max__; ++k_0__) {
                count[k_0__] = vals_i__[pos__++];
            }
            size_t count_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < count_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "count[i_0__]", count[i_0__], 0);
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("exposure", "Nobs", Nobs);
            context__.validate_dims("data initialization", "exposure", "vector_d", context__.to_vec(Nobs));
            exposure = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("exposure");
            pos__ = 0;
            size_t exposure_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < exposure_j_1_max__; ++j_1__) {
                exposure(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("mu_prior", "2", 2);
            context__.validate_dims("data initialization", "mu_prior", "vector_d", context__.to_vec(2));
            mu_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("mu_prior");
            pos__ = 0;
            size_t mu_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < mu_prior_j_1_max__; ++j_1__) {
                mu_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("alpha_prior", "2", 2);
            context__.validate_dims("data initialization", "alpha_prior", "vector_d", context__.to_vec(2));
            alpha_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("alpha_prior");
            pos__ = 0;
            size_t alpha_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < alpha_prior_j_1_max__; ++j_1__) {
                alpha_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 45;
            validate_non_negative_index("ED50_prior", "2", 2);
            context__.validate_dims("data initialization", "ED50_prior", "vector_d", context__.to_vec(2));
            ED50_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("ED50_prior");
            pos__ = 0;
            size_t ED50_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < ED50_prior_j_1_max__; ++j_1__) {
                ED50_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "tau_prior", "double", context__.to_vec());
            tau_prior = double(0);
            vals_r__ = context__.vals_r("tau_prior");
            pos__ = 0;
            tau_prior = vals_r__[pos__++];
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "tau_prior_dist", "int", context__.to_vec());
            tau_prior_dist = int(0);
            vals_i__ = context__.vals_i("tau_prior_dist");
            pos__ = 0;
            tau_prior_dist = vals_i__[pos__++];
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "ED50_prior_dist", "int", context__.to_vec());
            ED50_prior_dist = int(0);
            vals_i__ = context__.vals_i("ED50_prior_dist");
            pos__ = 0;
            ED50_prior_dist = vals_i__[pos__++];
            current_statement_begin__ = 49;
            validate_non_negative_index("gamma_prior", "2", 2);
            context__.validate_dims("data initialization", "gamma_prior", "vector_d", context__.to_vec(2));
            gamma_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("gamma_prior");
            pos__ = 0;
            size_t gamma_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < gamma_prior_j_1_max__; ++j_1__) {
                gamma_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 53;
            context__.validate_dims("data initialization", "Npred", "int", context__.to_vec());
            Npred = int(0);
            vals_i__ = context__.vals_i("Npred");
            pos__ = 0;
            Npred = vals_i__[pos__++];
            check_greater_or_equal(function__, "Npred", Npred, 1);
            current_statement_begin__ = 56;
            validate_non_negative_index("Pred_doses", "Npred", Npred);
            context__.validate_dims("data initialization", "Pred_doses", "double", context__.to_vec(Npred));
            Pred_doses = std::vector<double>(Npred, double(0));
            vals_r__ = context__.vals_r("Pred_doses");
            pos__ = 0;
            size_t Pred_doses_k_0_max__ = Npred;
            for (size_t k_0__ = 0; k_0__ < Pred_doses_k_0_max__; ++k_0__) {
                Pred_doses[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 59;
            validate_non_negative_index("b_ndx", "Nst", Nst);
            context__.validate_dims("data initialization", "b_ndx", "int", context__.to_vec(Nst));
            b_ndx = std::vector<int>(Nst, int(0));
            vals_i__ = context__.vals_i("b_ndx");
            pos__ = 0;
            size_t b_ndx_k_0_max__ = Nst;
            for (size_t k_0__ = 0; k_0__ < b_ndx_k_0_max__; ++k_0__) {
                b_ndx[k_0__] = vals_i__[pos__++];
            }
            size_t b_ndx_i_0_max__ = Nst;
            for (size_t i_0__ = 0; i_0__ < b_ndx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "b_ndx[i_0__]", b_ndx[i_0__], 1);
            }
            current_statement_begin__ = 62;
            validate_non_negative_index("t_ndx", "(Nobs - Nst)", (Nobs - Nst));
            context__.validate_dims("data initialization", "t_ndx", "int", context__.to_vec((Nobs - Nst)));
            t_ndx = std::vector<int>((Nobs - Nst), int(0));
            vals_i__ = context__.vals_i("t_ndx");
            pos__ = 0;
            size_t t_ndx_k_0_max__ = (Nobs - Nst);
            for (size_t k_0__ = 0; k_0__ < t_ndx_k_0_max__; ++k_0__) {
                t_ndx[k_0__] = vals_i__[pos__++];
            }
            size_t t_ndx_i_0_max__ = (Nobs - Nst);
            for (size_t i_0__ = 0; i_0__ < t_ndx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "t_ndx[i_0__]", t_ndx[i_0__], 1);
            }
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "re", "int", context__.to_vec());
            re = int(0);
            vals_i__ = context__.vals_i("re");
            pos__ = 0;
            re = vals_i__[pos__++];
            check_greater_or_equal(function__, "re", re, 0);
            check_less_or_equal(function__, "re", re, 1);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "ncp", "int", context__.to_vec());
            ncp = int(0);
            vals_i__ = context__.vals_i("ncp");
            pos__ = 0;
            ncp = vals_i__[pos__++];
            check_greater_or_equal(function__, "ncp", ncp, 0);
            check_less_or_equal(function__, "ncp", ncp, 1);
            // initialize transformed data variables
            current_statement_begin__ = 73;
            emax = int(0);
            stan::math::fill(emax, std::numeric_limits<int>::min());
            current_statement_begin__ = 75;
            hill = int(0);
            stan::math::fill(hill, std::numeric_limits<int>::min());
            current_statement_begin__ = 77;
            maxdose = double(0);
            stan::math::fill(maxdose, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 79;
            if (as_bool(logical_eq(dose_response, 1))) {
                current_statement_begin__ = 80;
                stan::math::assign(emax, 0);
                current_statement_begin__ = 81;
                stan::math::assign(hill, 0);
            }
            current_statement_begin__ = 83;
            if (as_bool(logical_eq(dose_response, 2))) {
                current_statement_begin__ = 84;
                stan::math::assign(emax, 0);
                current_statement_begin__ = 85;
                stan::math::assign(hill, 0);
            }
            current_statement_begin__ = 87;
            if (as_bool(logical_eq(dose_response, 3))) {
                current_statement_begin__ = 88;
                stan::math::assign(emax, 1);
                current_statement_begin__ = 89;
                stan::math::assign(hill, 0);
            }
            current_statement_begin__ = 91;
            if (as_bool(logical_eq(dose_response, 4))) {
                current_statement_begin__ = 92;
                stan::math::assign(emax, 1);
                current_statement_begin__ = 93;
                stan::math::assign(hill, 1);
            }
            current_statement_begin__ = 96;
            stan::math::assign(maxdose, max(dose));
            // validate transformed data
            current_statement_begin__ = 73;
            check_greater_or_equal(function__, "emax", emax, 0);
            check_less_or_equal(function__, "emax", emax, 1);
            current_statement_begin__ = 75;
            check_greater_or_equal(function__, "hill", hill, 0);
            check_less_or_equal(function__, "hill", hill, 1);
            current_statement_begin__ = 77;
            check_greater_or_equal(function__, "maxdose", maxdose, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 102;
            validate_non_negative_index("mu", "Nst", Nst);
            num_params_r__ += Nst;
            current_statement_begin__ = 103;
            num_params_r__ += 1;
            current_statement_begin__ = 104;
            validate_non_negative_index("ED50_raw", "emax", emax);
            num_params_r__ += (1 * emax);
            current_statement_begin__ = 105;
            validate_non_negative_index("gamma", "hill", hill);
            num_params_r__ += (1 * hill);
            current_statement_begin__ = 106;
            validate_non_negative_index("u", "(Nobs - Nst)", (Nobs - Nst));
            num_params_r__ += (Nobs - Nst);
            current_statement_begin__ = 107;
            validate_non_negative_index("tau", "re", re);
            num_params_r__ += (1 * re);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_MBMA() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 102;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "Nst", Nst);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(Nst));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu(Nst);
        size_t mu_j_1_max__ = Nst;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 103;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 104;
        if (!(context__.contains_r("ED50_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ED50_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ED50_raw");
        pos__ = 0U;
        validate_non_negative_index("ED50_raw", "emax", emax);
        context__.validate_dims("parameter initialization", "ED50_raw", "double", context__.to_vec(emax));
        std::vector<double> ED50_raw(emax, double(0));
        size_t ED50_raw_k_0_max__ = emax;
        for (size_t k_0__ = 0; k_0__ < ED50_raw_k_0_max__; ++k_0__) {
            ED50_raw[k_0__] = vals_r__[pos__++];
        }
        size_t ED50_raw_i_0_max__ = emax;
        for (size_t i_0__ = 0; i_0__ < ED50_raw_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0, 1.5, ED50_raw[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ED50_raw: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 105;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "hill", hill);
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec(hill));
        std::vector<double> gamma(hill, double(0));
        size_t gamma_k_0_max__ = hill;
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            gamma[k_0__] = vals_r__[pos__++];
        }
        size_t gamma_i_0_max__ = hill;
        for (size_t i_0__ = 0; i_0__ < gamma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0.5, 10, gamma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 106;
        if (!(context__.contains_r("u")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable u missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("u");
        pos__ = 0U;
        validate_non_negative_index("u", "(Nobs - Nst)", (Nobs - Nst));
        context__.validate_dims("parameter initialization", "u", "vector_d", context__.to_vec((Nobs - Nst)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> u((Nobs - Nst));
        size_t u_j_1_max__ = (Nobs - Nst);
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            u(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(u);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable u: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 107;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "re", re);
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec(re));
        std::vector<double> tau(re, double(0));
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            tau[k_0__] = vals_r__[pos__++];
        }
        size_t tau_i_0_max__ = re;
        for (size_t i_0__ = 0; i_0__ < tau_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, tau[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 102;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.vector_constrain(Nst, lp__);
            else
                mu = in__.vector_constrain(Nst);
            current_statement_begin__ = 103;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();
            current_statement_begin__ = 104;
            std::vector<local_scalar_t__> ED50_raw;
            size_t ED50_raw_d_0_max__ = emax;
            ED50_raw.reserve(ED50_raw_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ED50_raw_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ED50_raw.push_back(in__.scalar_lub_constrain(0, 1.5, lp__));
                else
                    ED50_raw.push_back(in__.scalar_lub_constrain(0, 1.5));
            }
            current_statement_begin__ = 105;
            std::vector<local_scalar_t__> gamma;
            size_t gamma_d_0_max__ = hill;
            gamma.reserve(gamma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gamma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gamma.push_back(in__.scalar_lub_constrain(0.5, 10, lp__));
                else
                    gamma.push_back(in__.scalar_lub_constrain(0.5, 10));
            }
            current_statement_begin__ = 106;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> u;
            (void) u;  // dummy to suppress unused var warning
            if (jacobian__)
                u = in__.vector_constrain((Nobs - Nst), lp__);
            else
                u = in__.vector_constrain((Nobs - Nst));
            current_statement_begin__ = 107;
            std::vector<local_scalar_t__> tau;
            size_t tau_d_0_max__ = re;
            tau.reserve(tau_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
                if (jacobian__)
                    tau.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    tau.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 111;
            validate_non_negative_index("delta_param", "(Nobs - Nst)", (Nobs - Nst));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_param((Nobs - Nst));
            stan::math::initialize(delta_param, DUMMY_VAR__);
            stan::math::fill(delta_param, DUMMY_VAR__);
            current_statement_begin__ = 112;
            validate_non_negative_index("Sigma", "max(ndose)", max(ndose));
            validate_non_negative_index("Sigma", "max(ndose)", max(ndose));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma(max(ndose), max(ndose));
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 113;
            validate_non_negative_index("Sigma_chol", "max(ndose)", max(ndose));
            validate_non_negative_index("Sigma_chol", "max(ndose)", max(ndose));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma_chol(max(ndose), max(ndose));
            stan::math::initialize(Sigma_chol, DUMMY_VAR__);
            stan::math::fill(Sigma_chol, DUMMY_VAR__);
            current_statement_begin__ = 114;
            validate_non_negative_index("md", "Nobs", Nobs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> md(Nobs);
            stan::math::initialize(md, DUMMY_VAR__);
            stan::math::fill(md, DUMMY_VAR__);
            current_statement_begin__ = 115;
            validate_non_negative_index("delta", "Nobs", Nobs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta(Nobs);
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 116;
            validate_non_negative_index("theta", "Nobs", Nobs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(Nobs);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 117;
            validate_non_negative_index("ED50", "emax", emax);
            std::vector<local_scalar_t__> ED50(emax, local_scalar_t__(0));
            stan::math::initialize(ED50, DUMMY_VAR__);
            stan::math::fill(ED50, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 120;
            if (as_bool(logical_eq(emax, 1))) {
                current_statement_begin__ = 120;
                stan::model::assign(ED50, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(ED50_raw, 1, "ED50_raw", 1) * maxdose), 
                            "assigning variable ED50");
            }
            current_statement_begin__ = 123;
            for (int i = 1; i <= Nobs; ++i) {
                current_statement_begin__ = 124;
                if (as_bool(logical_eq(dose_response, 1))) {
                    current_statement_begin__ = 124;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * get_base1(dose, i, "dose", 1)), 
                                "assigning variable md");
                }
                current_statement_begin__ = 125;
                if (as_bool(logical_eq(dose_response, 2))) {
                    current_statement_begin__ = 125;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * stan::math::log((get_base1(dose, i, "dose", 1) + 1))), 
                                "assigning variable md");
                }
                current_statement_begin__ = 126;
                if (as_bool(logical_eq(dose_response, 3))) {
                    current_statement_begin__ = 126;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * get_base1(dose, i, "dose", 1)) / (get_base1(ED50, 1, "ED50", 1) + get_base1(dose, i, "dose", 1))), 
                                "assigning variable md");
                }
                current_statement_begin__ = 127;
                if (as_bool(logical_eq(dose_response, 4))) {
                    current_statement_begin__ = 127;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * pow(get_base1(dose, i, "dose", 1), get_base1(gamma, 1, "gamma", 1))) / (pow(get_base1(ED50, 1, "ED50", 1), get_base1(gamma, 1, "gamma", 1)) + pow(get_base1(dose, i, "dose", 1), get_base1(gamma, 1, "gamma", 1)))), 
                                "assigning variable md");
                }
            }
            current_statement_begin__ = 131;
            for (int i = 1; i <= max(ndose); ++i) {
                current_statement_begin__ = 132;
                stan::model::assign(Sigma, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(get_base1(tau, 1, "tau", 1), 2), 
                            "assigning variable Sigma");
                current_statement_begin__ = 133;
                for (int j = (i + 1); j <= max(ndose); ++j) {
                    current_statement_begin__ = 134;
                    stan::model::assign(Sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (pow(get_base1(tau, 1, "tau", 1), 2) / 2), 
                                "assigning variable Sigma");
                    current_statement_begin__ = 135;
                    stan::model::assign(Sigma, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                get_base1(Sigma, i, j, "Sigma", 1), 
                                "assigning variable Sigma");
                }
            }
            current_statement_begin__ = 139;
            stan::math::assign(Sigma_chol, cholesky_decompose(Sigma));
            {
            current_statement_begin__ = 142;
            int pos_delta(0);
            (void) pos_delta;  // dummy to suppress unused var warning
            stan::math::fill(pos_delta, std::numeric_limits<int>::min());
            current_statement_begin__ = 143;
            int pos_md(0);
            (void) pos_md;  // dummy to suppress unused var warning
            stan::math::fill(pos_md, std::numeric_limits<int>::min());
            current_statement_begin__ = 144;
            stan::math::assign(pos_delta, 1);
            current_statement_begin__ = 145;
            stan::math::assign(pos_md, 2);
            current_statement_begin__ = 146;
            for (int j = 1; j <= Nst; ++j) {
                current_statement_begin__ = 147;
                if (as_bool(logical_eq(get_base1(ndose, j, "ndose", 1), 2))) {
                    current_statement_begin__ = 148;
                    stan::model::assign(delta_param, 
                                stan::model::cons_list(stan::model::index_uni(pos_delta), stan::model::nil_index_list()), 
                                (get_base1(md, pos_md, "md", 1) + (get_base1(tau, 1, "tau", 1) * get_base1(u, pos_delta, "u", 1))), 
                                "assigning variable delta_param");
                } else {
                    current_statement_begin__ = 150;
                    stan::model::assign(delta_param, 
                                stan::model::cons_list(stan::model::index_min_max(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(md, stan::model::cons_list(stan::model::index_min_max(pos_md, ((pos_md + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), "md"), multiply(stan::model::rvalue(Sigma_chol, stan::model::cons_list(stan::model::index_min_max(1, (get_base1(ndose, j, "ndose", 1) - 1)), stan::model::cons_list(stan::model::index_min_max(1, (get_base1(ndose, j, "ndose", 1) - 1)), stan::model::nil_index_list())), "Sigma_chol"), stan::model::rvalue(u, stan::model::cons_list(stan::model::index_min_max(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), "u"))), 
                                "assigning variable delta_param");
                }
                current_statement_begin__ = 153;
                stan::math::assign(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 1));
                current_statement_begin__ = 154;
                stan::math::assign(pos_md, (pos_md + get_base1(ndose, j, "ndose", 1)));
            }
            }
            current_statement_begin__ = 159;
            for (int i = 1; i <= Nst; ++i) {
                current_statement_begin__ = 160;
                stan::model::assign(delta, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(b_ndx, i, "b_ndx", 1)), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable delta");
            }
            current_statement_begin__ = 161;
            for (int i = 1; i <= (Nobs - Nst); ++i) {
                current_statement_begin__ = 162;
                stan::model::assign(delta, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(t_ndx, i, "t_ndx", 1)), stan::model::nil_index_list()), 
                            get_base1(delta_param, i, "delta_param", 1), 
                            "assigning variable delta");
            }
            current_statement_begin__ = 164;
            if (as_bool(re)) {
                current_statement_begin__ = 165;
                if (as_bool(ncp)) {
                    current_statement_begin__ = 166;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 167;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + get_base1(delta, i, "delta", 1)), 
                                    "assigning variable theta");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 111;
            size_t delta_param_j_1_max__ = (Nobs - Nst);
            for (size_t j_1__ = 0; j_1__ < delta_param_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta_param(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta_param" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta_param: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 112;
            size_t Sigma_j_1_max__ = max(ndose);
            size_t Sigma_j_2_max__ = max(ndose);
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Sigma(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Sigma" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            stan::math::check_cov_matrix(function__, "Sigma", Sigma);
            current_statement_begin__ = 113;
            size_t Sigma_chol_j_1_max__ = max(ndose);
            size_t Sigma_chol_j_2_max__ = max(ndose);
            for (size_t j_1__ = 0; j_1__ < Sigma_chol_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Sigma_chol_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Sigma_chol(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Sigma_chol" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Sigma_chol: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 114;
            size_t md_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < md_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(md(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: md" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable md: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 115;
            size_t delta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 116;
            size_t theta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 117;
            size_t ED50_k_0_max__ = emax;
            for (size_t k_0__ = 0; k_0__ < ED50_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(ED50[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ED50" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ED50: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t ED50_i_0_max__ = emax;
            for (size_t i_0__ = 0; i_0__ < ED50_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ED50[i_0__]", ED50[i_0__], 0);
            }
            // model body
            {
            current_statement_begin__ = 176;
            int pos_delta(0);
            (void) pos_delta;  // dummy to suppress unused var warning
            stan::math::fill(pos_delta, std::numeric_limits<int>::min());
            current_statement_begin__ = 177;
            stan::math::assign(pos_delta, 1);
            current_statement_begin__ = 178;
            for (int j = 1; j <= Nst; ++j) {
                current_statement_begin__ = 179;
                if (as_bool(logical_eq(get_base1(ndose, j, "ndose", 1), 2))) {
                    current_statement_begin__ = 180;
                    lp_accum__.add(normal_log<propto__>(get_base1(u, pos_delta, "u", 1), 0, 1));
                } else {
                    current_statement_begin__ = 182;
                    lp_accum__.add(normal_log<propto__>(stan::model::rvalue(u, stan::model::cons_list(stan::model::index_min_max(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), "u"), 0, 1));
                }
                current_statement_begin__ = 184;
                stan::math::assign(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 1));
            }
            }
            current_statement_begin__ = 191;
            lp_accum__.add(normal_log<propto__>(mu, get_base1(mu_prior, 1, "mu_prior", 1), get_base1(mu_prior, 2, "mu_prior", 1)));
            current_statement_begin__ = 192;
            lp_accum__.add(normal_log<propto__>(alpha, get_base1(alpha_prior, 1, "alpha_prior", 1), get_base1(alpha_prior, 2, "alpha_prior", 1)));
            current_statement_begin__ = 194;
            if (as_bool(logical_eq(emax, 1))) {
                current_statement_begin__ = 196;
                if (as_bool(logical_eq(ED50_prior_dist, 1))) {
                    current_statement_begin__ = 196;
                    lp_accum__.add(lognormal_log<propto__>(get_base1(ED50_raw, 1, "ED50_raw", 1), get_base1(ED50_prior, 1, "ED50_prior", 1), get_base1(ED50_prior, 2, "ED50_prior", 1)));
                }
                current_statement_begin__ = 198;
                if (as_bool(logical_eq(ED50_prior_dist, 2))) {
                    current_statement_begin__ = 198;
                    lp_accum__.add(normal_log<propto__>(get_base1(ED50_raw, 1, "ED50_raw", 1), get_base1(ED50_prior, 1, "ED50_prior", 1), get_base1(ED50_prior, 2, "ED50_prior", 1)));
                    if (get_base1(ED50_raw, 1, "ED50_raw", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-normal_ccdf_log(0, get_base1(ED50_prior, 1, "ED50_prior", 1), get_base1(ED50_prior, 2, "ED50_prior", 1)));
                }
                current_statement_begin__ = 200;
                if (as_bool(logical_eq(ED50_prior_dist, 3))) {
                    current_statement_begin__ = 200;
                    lp_accum__.add(uniform_log<propto__>(get_base1(ED50_raw, 1, "ED50_raw", 1), 0, get_base1(ED50_prior, 1, "ED50_prior", 1)));
                }
            }
            current_statement_begin__ = 204;
            if (as_bool(logical_eq(hill, 1))) {
                current_statement_begin__ = 204;
                lp_accum__.add(normal_log<propto__>(get_base1(gamma, 1, "gamma", 1), get_base1(gamma_prior, 1, "gamma_prior", 1), get_base1(gamma_prior, 2, "gamma_prior", 1)));
                if (get_base1(gamma, 1, "gamma", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, get_base1(gamma_prior, 1, "gamma_prior", 1), get_base1(gamma_prior, 2, "gamma_prior", 1)));
            }
            current_statement_begin__ = 207;
            if (as_bool(logical_eq(tau_prior_dist, 1))) {
                current_statement_begin__ = 207;
                lp_accum__.add(normal_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
                if (get_base1(tau, 1, "tau", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 0, tau_prior));
            }
            current_statement_begin__ = 208;
            if (as_bool(logical_eq(tau_prior_dist, 2))) {
                current_statement_begin__ = 208;
                lp_accum__.add(uniform_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
            }
            current_statement_begin__ = 209;
            if (as_bool(logical_eq(tau_prior_dist, 3))) {
                current_statement_begin__ = 209;
                lp_accum__.add(cauchy_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
                if (get_base1(tau, 1, "tau", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-cauchy_ccdf_log(0, 0, tau_prior));
            }
            current_statement_begin__ = 212;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 212;
                lp_accum__.add(normal_log<propto__>(y, theta, y_se));
            }
            current_statement_begin__ = 213;
            if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 213;
                lp_accum__.add(binomial_logit_log<propto__>(r, n, theta));
            }
            current_statement_begin__ = 214;
            if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 214;
                lp_accum__.add(poisson_log_log<propto__>(count, add(exposure, theta)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("alpha");
        names__.push_back("ED50_raw");
        names__.push_back("gamma");
        names__.push_back("u");
        names__.push_back("tau");
        names__.push_back("delta_param");
        names__.push_back("Sigma");
        names__.push_back("Sigma_chol");
        names__.push_back("md");
        names__.push_back("delta");
        names__.push_back("theta");
        names__.push_back("ED50");
        names__.push_back("mean_mu");
        names__.push_back("md_pred");
        names__.push_back("delta_pred");
        names__.push_back("Pred_probs");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(Nst);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(emax);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(hill);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((Nobs - Nst));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((Nobs - Nst));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(max(ndose));
        dims__.push_back(max(ndose));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(max(ndose));
        dims__.push_back(max(ndose));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(emax);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_MBMA_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu = in__.vector_constrain(Nst);
        size_t mu_j_1_max__ = Nst;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            vars__.push_back(mu(j_1__));
        }
        double alpha = in__.scalar_constrain();
        vars__.push_back(alpha);
        std::vector<double> ED50_raw;
        size_t ED50_raw_d_0_max__ = emax;
        ED50_raw.reserve(ED50_raw_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ED50_raw_d_0_max__; ++d_0__) {
            ED50_raw.push_back(in__.scalar_lub_constrain(0, 1.5));
        }
        size_t ED50_raw_k_0_max__ = emax;
        for (size_t k_0__ = 0; k_0__ < ED50_raw_k_0_max__; ++k_0__) {
            vars__.push_back(ED50_raw[k_0__]);
        }
        std::vector<double> gamma;
        size_t gamma_d_0_max__ = hill;
        gamma.reserve(gamma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gamma_d_0_max__; ++d_0__) {
            gamma.push_back(in__.scalar_lub_constrain(0.5, 10));
        }
        size_t gamma_k_0_max__ = hill;
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> u = in__.vector_constrain((Nobs - Nst));
        size_t u_j_1_max__ = (Nobs - Nst);
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            vars__.push_back(u(j_1__));
        }
        std::vector<double> tau;
        size_t tau_d_0_max__ = re;
        tau.reserve(tau_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
            tau.push_back(in__.scalar_lb_constrain(0));
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 111;
            validate_non_negative_index("delta_param", "(Nobs - Nst)", (Nobs - Nst));
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta_param((Nobs - Nst));
            stan::math::initialize(delta_param, DUMMY_VAR__);
            stan::math::fill(delta_param, DUMMY_VAR__);
            current_statement_begin__ = 112;
            validate_non_negative_index("Sigma", "max(ndose)", max(ndose));
            validate_non_negative_index("Sigma", "max(ndose)", max(ndose));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma(max(ndose), max(ndose));
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 113;
            validate_non_negative_index("Sigma_chol", "max(ndose)", max(ndose));
            validate_non_negative_index("Sigma_chol", "max(ndose)", max(ndose));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma_chol(max(ndose), max(ndose));
            stan::math::initialize(Sigma_chol, DUMMY_VAR__);
            stan::math::fill(Sigma_chol, DUMMY_VAR__);
            current_statement_begin__ = 114;
            validate_non_negative_index("md", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> md(Nobs);
            stan::math::initialize(md, DUMMY_VAR__);
            stan::math::fill(md, DUMMY_VAR__);
            current_statement_begin__ = 115;
            validate_non_negative_index("delta", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta(Nobs);
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 116;
            validate_non_negative_index("theta", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta(Nobs);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 117;
            validate_non_negative_index("ED50", "emax", emax);
            std::vector<double> ED50(emax, double(0));
            stan::math::initialize(ED50, DUMMY_VAR__);
            stan::math::fill(ED50, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 120;
            if (as_bool(logical_eq(emax, 1))) {
                current_statement_begin__ = 120;
                stan::model::assign(ED50, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(ED50_raw, 1, "ED50_raw", 1) * maxdose), 
                            "assigning variable ED50");
            }
            current_statement_begin__ = 123;
            for (int i = 1; i <= Nobs; ++i) {
                current_statement_begin__ = 124;
                if (as_bool(logical_eq(dose_response, 1))) {
                    current_statement_begin__ = 124;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * get_base1(dose, i, "dose", 1)), 
                                "assigning variable md");
                }
                current_statement_begin__ = 125;
                if (as_bool(logical_eq(dose_response, 2))) {
                    current_statement_begin__ = 125;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * stan::math::log((get_base1(dose, i, "dose", 1) + 1))), 
                                "assigning variable md");
                }
                current_statement_begin__ = 126;
                if (as_bool(logical_eq(dose_response, 3))) {
                    current_statement_begin__ = 126;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * get_base1(dose, i, "dose", 1)) / (get_base1(ED50, 1, "ED50", 1) + get_base1(dose, i, "dose", 1))), 
                                "assigning variable md");
                }
                current_statement_begin__ = 127;
                if (as_bool(logical_eq(dose_response, 4))) {
                    current_statement_begin__ = 127;
                    stan::model::assign(md, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * pow(get_base1(dose, i, "dose", 1), get_base1(gamma, 1, "gamma", 1))) / (pow(get_base1(ED50, 1, "ED50", 1), get_base1(gamma, 1, "gamma", 1)) + pow(get_base1(dose, i, "dose", 1), get_base1(gamma, 1, "gamma", 1)))), 
                                "assigning variable md");
                }
            }
            current_statement_begin__ = 131;
            for (int i = 1; i <= max(ndose); ++i) {
                current_statement_begin__ = 132;
                stan::model::assign(Sigma, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(get_base1(tau, 1, "tau", 1), 2), 
                            "assigning variable Sigma");
                current_statement_begin__ = 133;
                for (int j = (i + 1); j <= max(ndose); ++j) {
                    current_statement_begin__ = 134;
                    stan::model::assign(Sigma, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (pow(get_base1(tau, 1, "tau", 1), 2) / 2), 
                                "assigning variable Sigma");
                    current_statement_begin__ = 135;
                    stan::model::assign(Sigma, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                get_base1(Sigma, i, j, "Sigma", 1), 
                                "assigning variable Sigma");
                }
            }
            current_statement_begin__ = 139;
            stan::math::assign(Sigma_chol, cholesky_decompose(Sigma));
            {
            current_statement_begin__ = 142;
            int pos_delta(0);
            (void) pos_delta;  // dummy to suppress unused var warning
            stan::math::fill(pos_delta, std::numeric_limits<int>::min());
            current_statement_begin__ = 143;
            int pos_md(0);
            (void) pos_md;  // dummy to suppress unused var warning
            stan::math::fill(pos_md, std::numeric_limits<int>::min());
            current_statement_begin__ = 144;
            stan::math::assign(pos_delta, 1);
            current_statement_begin__ = 145;
            stan::math::assign(pos_md, 2);
            current_statement_begin__ = 146;
            for (int j = 1; j <= Nst; ++j) {
                current_statement_begin__ = 147;
                if (as_bool(logical_eq(get_base1(ndose, j, "ndose", 1), 2))) {
                    current_statement_begin__ = 148;
                    stan::model::assign(delta_param, 
                                stan::model::cons_list(stan::model::index_uni(pos_delta), stan::model::nil_index_list()), 
                                (get_base1(md, pos_md, "md", 1) + (get_base1(tau, 1, "tau", 1) * get_base1(u, pos_delta, "u", 1))), 
                                "assigning variable delta_param");
                } else {
                    current_statement_begin__ = 150;
                    stan::model::assign(delta_param, 
                                stan::model::cons_list(stan::model::index_min_max(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(md, stan::model::cons_list(stan::model::index_min_max(pos_md, ((pos_md + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), "md"), multiply(stan::model::rvalue(Sigma_chol, stan::model::cons_list(stan::model::index_min_max(1, (get_base1(ndose, j, "ndose", 1) - 1)), stan::model::cons_list(stan::model::index_min_max(1, (get_base1(ndose, j, "ndose", 1) - 1)), stan::model::nil_index_list())), "Sigma_chol"), stan::model::rvalue(u, stan::model::cons_list(stan::model::index_min_max(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 2)), stan::model::nil_index_list()), "u"))), 
                                "assigning variable delta_param");
                }
                current_statement_begin__ = 153;
                stan::math::assign(pos_delta, ((pos_delta + get_base1(ndose, j, "ndose", 1)) - 1));
                current_statement_begin__ = 154;
                stan::math::assign(pos_md, (pos_md + get_base1(ndose, j, "ndose", 1)));
            }
            }
            current_statement_begin__ = 159;
            for (int i = 1; i <= Nst; ++i) {
                current_statement_begin__ = 160;
                stan::model::assign(delta, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(b_ndx, i, "b_ndx", 1)), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable delta");
            }
            current_statement_begin__ = 161;
            for (int i = 1; i <= (Nobs - Nst); ++i) {
                current_statement_begin__ = 162;
                stan::model::assign(delta, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(t_ndx, i, "t_ndx", 1)), stan::model::nil_index_list()), 
                            get_base1(delta_param, i, "delta_param", 1), 
                            "assigning variable delta");
            }
            current_statement_begin__ = 164;
            if (as_bool(re)) {
                current_statement_begin__ = 165;
                if (as_bool(ncp)) {
                    current_statement_begin__ = 166;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 167;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + get_base1(delta, i, "delta", 1)), 
                                    "assigning variable theta");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 112;
            stan::math::check_cov_matrix(function__, "Sigma", Sigma);
            current_statement_begin__ = 117;
            size_t ED50_i_0_max__ = emax;
            for (size_t i_0__ = 0; i_0__ < ED50_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ED50[i_0__]", ED50[i_0__], 0);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t delta_param_j_1_max__ = (Nobs - Nst);
                for (size_t j_1__ = 0; j_1__ < delta_param_j_1_max__; ++j_1__) {
                    vars__.push_back(delta_param(j_1__));
                }
                size_t Sigma_j_2_max__ = max(ndose);
                size_t Sigma_j_1_max__ = max(ndose);
                for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                        vars__.push_back(Sigma(j_1__, j_2__));
                    }
                }
                size_t Sigma_chol_j_2_max__ = max(ndose);
                size_t Sigma_chol_j_1_max__ = max(ndose);
                for (size_t j_2__ = 0; j_2__ < Sigma_chol_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Sigma_chol_j_1_max__; ++j_1__) {
                        vars__.push_back(Sigma_chol(j_1__, j_2__));
                    }
                }
                size_t md_j_1_max__ = Nobs;
                for (size_t j_1__ = 0; j_1__ < md_j_1_max__; ++j_1__) {
                    vars__.push_back(md(j_1__));
                }
                size_t delta_j_1_max__ = Nobs;
                for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                    vars__.push_back(delta(j_1__));
                }
                size_t theta_j_1_max__ = Nobs;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    vars__.push_back(theta(j_1__));
                }
                size_t ED50_k_0_max__ = emax;
                for (size_t k_0__ = 0; k_0__ < ED50_k_0_max__; ++k_0__) {
                    vars__.push_back(ED50[k_0__]);
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 219;
            double mean_mu;
            (void) mean_mu;  // dummy to suppress unused var warning
            stan::math::initialize(mean_mu, DUMMY_VAR__);
            stan::math::fill(mean_mu, DUMMY_VAR__);
            current_statement_begin__ = 220;
            validate_non_negative_index("md_pred", "Npred", Npred);
            std::vector<double> md_pred(Npred, double(0));
            stan::math::initialize(md_pred, DUMMY_VAR__);
            stan::math::fill(md_pred, DUMMY_VAR__);
            current_statement_begin__ = 221;
            validate_non_negative_index("delta_pred", "Npred", Npred);
            std::vector<double> delta_pred(Npred, double(0));
            stan::math::initialize(delta_pred, DUMMY_VAR__);
            stan::math::fill(delta_pred, DUMMY_VAR__);
            current_statement_begin__ = 222;
            validate_non_negative_index("Pred_probs", "Npred", Npred);
            std::vector<double> Pred_probs(Npred, double(0));
            stan::math::initialize(Pred_probs, DUMMY_VAR__);
            stan::math::fill(Pred_probs, DUMMY_VAR__);
            current_statement_begin__ = 223;
            validate_non_negative_index("log_lik", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(Nobs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 226;
            stan::math::assign(mean_mu, mean(mu));
            current_statement_begin__ = 228;
            stan::model::assign(Pred_probs, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        inv_logit(mean(mu)), 
                        "assigning variable Pred_probs");
            current_statement_begin__ = 229;
            stan::model::assign(md_pred, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable md_pred");
            current_statement_begin__ = 230;
            stan::model::assign(delta_pred, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable delta_pred");
            current_statement_begin__ = 231;
            for (int i = 2; i <= num_elements(Pred_doses); ++i) {
                current_statement_begin__ = 232;
                if (as_bool(logical_eq(dose_response, 1))) {
                    current_statement_begin__ = 232;
                    stan::model::assign(md_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * get_base1(Pred_doses, i, "Pred_doses", 1)), 
                                "assigning variable md_pred");
                }
                current_statement_begin__ = 233;
                if (as_bool(logical_eq(dose_response, 2))) {
                    current_statement_begin__ = 233;
                    stan::model::assign(md_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (alpha * stan::math::log((get_base1(Pred_doses, i, "Pred_doses", 1) + 1))), 
                                "assigning variable md_pred");
                }
                current_statement_begin__ = 234;
                if (as_bool(logical_eq(dose_response, 3))) {
                    current_statement_begin__ = 234;
                    stan::model::assign(md_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * get_base1(Pred_doses, i, "Pred_doses", 1)) / (get_base1(ED50, 1, "ED50", 1) + get_base1(Pred_doses, i, "Pred_doses", 1))), 
                                "assigning variable md_pred");
                }
                current_statement_begin__ = 235;
                if (as_bool(logical_eq(dose_response, 4))) {
                    current_statement_begin__ = 235;
                    stan::model::assign(md_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((alpha * pow(get_base1(Pred_doses, i, "Pred_doses", 1), get_base1(gamma, 1, "gamma", 1))) / (pow(get_base1(ED50, 1, "ED50", 1), get_base1(gamma, 1, "gamma", 1)) + pow(get_base1(Pred_doses, i, "Pred_doses", 1), get_base1(gamma, 1, "gamma", 1)))), 
                                "assigning variable md_pred");
                }
                current_statement_begin__ = 238;
                stan::model::assign(delta_pred, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            normal_rng((mean_mu + get_base1(md_pred, i, "md_pred", 1)), get_base1(tau, 1, "tau", 1), base_rng__), 
                            "assigning variable delta_pred");
                current_statement_begin__ = 239;
                stan::model::assign(Pred_probs, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            inv_logit(get_base1(delta_pred, i, "delta_pred", 1)), 
                            "assigning variable Pred_probs");
            }
            current_statement_begin__ = 242;
            for (int s = 1; s <= Nobs; ++s) {
                current_statement_begin__ = 243;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 243;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                normal_log(y, get_base1(theta, s, "theta", 1), get_base1(y_se, s, "y_se", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 244;
                if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 244;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                binomial_logit_log(get_base1(r, s, "r", 1), get_base1(n, s, "n", 1), get_base1(theta, s, "theta", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 245;
                if (as_bool(logical_eq(link, 3))) {
                    current_statement_begin__ = 245;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                poisson_log_log(get_base1(count, s, "count", 1), (get_base1(exposure, s, "exposure", 1) + get_base1(theta, s, "theta", 1))), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 219;
            vars__.push_back(mean_mu);
            current_statement_begin__ = 220;
            size_t md_pred_k_0_max__ = Npred;
            for (size_t k_0__ = 0; k_0__ < md_pred_k_0_max__; ++k_0__) {
                vars__.push_back(md_pred[k_0__]);
            }
            current_statement_begin__ = 221;
            size_t delta_pred_k_0_max__ = Npred;
            for (size_t k_0__ = 0; k_0__ < delta_pred_k_0_max__; ++k_0__) {
                vars__.push_back(delta_pred[k_0__]);
            }
            current_statement_begin__ = 222;
            size_t Pred_probs_i_0_max__ = Npred;
            for (size_t i_0__ = 0; i_0__ < Pred_probs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "Pred_probs[i_0__]", Pred_probs[i_0__], 0);
                check_less_or_equal(function__, "Pred_probs[i_0__]", Pred_probs[i_0__], 1);
            }
            size_t Pred_probs_k_0_max__ = Npred;
            for (size_t k_0__ = 0; k_0__ < Pred_probs_k_0_max__; ++k_0__) {
                vars__.push_back(Pred_probs[k_0__]);
            }
            current_statement_begin__ = 223;
            size_t log_lik_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_MBMA";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = Nst;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        size_t ED50_raw_k_0_max__ = emax;
        for (size_t k_0__ = 0; k_0__ < ED50_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ED50_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_k_0_max__ = hill;
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_j_1_max__ = (Nobs - Nst);
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t delta_param_j_1_max__ = (Nobs - Nst);
            for (size_t j_1__ = 0; j_1__ < delta_param_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_param" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Sigma_j_2_max__ = max(ndose);
            size_t Sigma_j_1_max__ = max(ndose);
            for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Sigma_chol_j_2_max__ = max(ndose);
            size_t Sigma_chol_j_1_max__ = max(ndose);
            for (size_t j_2__ = 0; j_2__ < Sigma_chol_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_chol_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_chol" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t md_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < md_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "md" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ED50_k_0_max__ = emax;
            for (size_t k_0__ = 0; k_0__ < ED50_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ED50" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_mu";
        param_names__.push_back(param_name_stream__.str());
        size_t md_pred_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < md_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "md_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_pred_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < delta_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Pred_probs_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < Pred_probs_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Pred_probs" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = Nst;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        size_t ED50_raw_k_0_max__ = emax;
        for (size_t k_0__ = 0; k_0__ < ED50_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ED50_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_k_0_max__ = hill;
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_j_1_max__ = (Nobs - Nst);
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t delta_param_j_1_max__ = (Nobs - Nst);
            for (size_t j_1__ = 0; j_1__ < delta_param_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_param" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Sigma_j_1_max__ = (max(ndose) + ((max(ndose) * (max(ndose) - 1)) / 2));
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Sigma_chol_j_2_max__ = max(ndose);
            size_t Sigma_chol_j_1_max__ = max(ndose);
            for (size_t j_2__ = 0; j_2__ < Sigma_chol_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_chol_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_chol" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t md_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < md_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "md" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ED50_k_0_max__ = emax;
            for (size_t k_0__ = 0; k_0__ < ED50_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ED50" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_mu";
        param_names__.push_back(param_name_stream__.str());
        size_t md_pred_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < md_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "md_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_pred_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < delta_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Pred_probs_k_0_max__ = Npred;
        for (size_t k_0__ = 0; k_0__ < Pred_probs_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Pred_probs" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_MBMA_namespace::model_MBMA stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
