% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_compare.R
\name{measure_compare}
\alias{measure_compare}
\title{Estimation of the amount of bias of the new measurement method relative to
the reference method}
\usage{
measure_compare(
  data,
  new = "y1",
  ref = "y2",
  id = "id",
  nb_simul = 1000,
  if_value = NULL
)
}
\arguments{
\item{data}{a required data frame containing the identification number of the
subject (\code{id}), the measurement values from the new method (\code{y1}) and
those from the reference method (\code{y2}).}

\item{new}{an optional string. The column name containing the measurements of the new
measurement method.}

\item{ref}{an optional string. The column name containing the measurements of the
reference method (at least two measurements per subject).}

\item{id}{an optional string. The column name containing the subject
identification numbers.}

\item{nb_simul}{an optional number. The number of simulations used for simultaneous
confidence bands.}

\item{if_value}{an optional number. Restrict the study to observed
measurement greater than the provided value, i.e., \code{y1 >= if_value && y2 >= if_value}.}
}
\value{
The function returns a list with the following items:
\itemize{
\item \code{models}: a list of models fitted in estimation procedure
\item \code{data}: the original data frame with renamed columns and
additional computed data
\item \code{sim_params}: estimated model coefficients used afterward
\item \code{nb_simul}: the number of simulations used for confidence bands
simulations
\item \code{bias}: differential and proportional biases for new method and the
associated 95 percent confidence intervals
\item \code{methods}: a list of methods names provided by the user
}
}
\description{
\code{measure_compare()} implements the methodology reported in the paper:
Taffé P. Effective plots to assess bias and precision in method comparison
studies. Stat Methods Med Res 2018;27:1650-1660. Other relevant references:
Taffé P, Peng M, Stagg V, Williamson T. Biasplot: A package to effective
plots to assess bias and precision in method comparison studies.
Stata J 2017;17:208-221. Taffé P, Peng M, Stagg V, Williamson T.
MethodCompare: An R package to assess bias and precision in method
comparison studies. Stat Methods Med Res 2019;28:2557-2565.
Taffé P, Halfon P, Halfon M. A new statistical methodology to assess bias
and precision overcomes the defects of the Bland & Altman method.
J Clin Epidemiol 2020;124:1-7. Taffé P. Assessing bias, precision, and
agreement in method comparison studies. Stat Methods Med Res 2020;29:778-796.
Taffé P. When can the Bland-Altman limits of agreement method be used and
when it should not be used. J Clin Epidemiol 2021; 137:176-181.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)}
}
