% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_plot.R
\name{precision_plot}
\alias{precision_plot}
\title{Plot the precision of the methods}
\usage{
precision_plot(object, object2 = NULL, log = FALSE, rarea = FALSE)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}

\item{object2}{(optional) returned by \link{measure_compare} function.
If provided, will plot a second precision estimate.}

\item{log}{if \code{TRUE}, guarantee the simultaneous confidence bands around the
standard deviation of measurement errors to be strictly positive.}

\item{rarea}{if \code{TRUE}, draw the plot with shading areas between
the confidence bands.}
}
\description{
This function draws the "precision plot", which allows the visual comparison
of the precision (i.e. standard deviation) of the new measurement method with
the reference standard by creating a scatter plot of the estimated standard
deviations, along with their 95\% simultaneous confidence bands, against the
best linear prediction (BLUP) of the true latent trait, \code{x}.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the precision of the two methods
precision_plot(measure_model)}
}
