% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxPHUni.R
\name{CoxPHUni}
\alias{CoxPHUni}
\title{This function will fit the full and reduced models and calculate LRT raw p-value and adjusted p-value based on BH Method}
\usage{
CoxPHUni(Survival, Censor, Prognostic, Micro.mat, Method = "BH")
}
\arguments{
\item{Survival}{The time to event outcome.}

\item{Censor}{An indicator variable indicate the subject is censored or not.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Micro.mat}{a microbiome matrix, can be at otu, family or any level of the ecosystem. Rows are taxa, columns are subjectsc.}

\item{Method}{A multiplicity adjustment Method that user can choose. The default is BH Method.}
}
\value{
A relative abundance matrix of OTUs
\item{coef}{coefficient of one microbiome (OTU or family, ...)}
\item{exp.coef}{exponential of the coefficient}
\item{p.value.LRT}{raw LRT p-value}
\item{p.value}{adjusted p-value based on chosen Method}
}
\description{
This function will fit the full and reduced models and calculate LRT raw p-value and adjusted p-value based on BH Method
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the funtion
summary_fam_shan_w3 = CoxPHUni(Survival = surv_fam_shan_w3$Survival,
                               Censor = surv_fam_shan_w3$Censor,
                               Prognostic = prog_fam_shan_w3,
                               Micro.mat = fam_shan_trim_w3,
                               Method = "BH")
}
\seealso{
\code{\link[MicrobiomeSurv]{CoxPHUni}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
