% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_migrations.R
\name{identify_migrations}
\alias{identify_migrations}
\title{identify_migrations}
\usage{
identify_migrations(
  segs,
  locs,
  min_res_length = 90,
  occurrence_locs = NULL,
  occurrence_times = NULL,
  verbose = TRUE
)
}
\arguments{
\item{segs}{A vector of \link[lubridate]{interval}, a vector of intervals which indicate residence segments, such as detected by \link{detect_segments}.}

\item{locs}{A vector of Character, locations which correspond to \code{segs}.}

\item{min_res_length}{(Optional) Numeric. A vector of days indicating the minimum number of days for \code{segs} to quality as viable origin or destination of a migration. Default is \code{90}.}

\item{occurrence_locs}{(Optional) Character. See \code{occurrence_times}}

\item{occurrence_times}{(Optional) If provided along with the matching \code{occurrence_times}, will try to find the optimal point in time during which the migration occurred.}

\item{verbose}{(Optional) logical. Output optional messages? Default is \code{TRUE}.}
}
\value{
A tibble containing the detected true relocations, if any. Contains the fields: \itemize{
\item{\strong{from} Character, the location from which the relocations started.}
\item{\strong{to} Character, the location from which the relocations started.}
\item{\strong{movement_interval} \link[lubridate]{interval} of the transitionary period, starting with the end of the prior residency and ending with the start of the new residency.}
\item{\strong{movement_length} The duration of the transitionary period in seconds.}
\item{\strong{movement_midrange} The midpoint of the transitionary period.}
}
If \code{occurrence_locs} and \code{occurrence_times} were provided, \link{find_best_split} will be used to detect the optimum split time, and the following columns will be added:\itemize{
\item{\strong{split_time}, a \link[lubridate]{POSIXct} which indicates the time of the optimal split. }
\item{\strong{split_correctness}, a numeric which as a quality measure of \code{splot_time} reports the split's ratio of wrongly assigned days to the correctly assigned days.}
}
}
\description{
identify_migrations
}
\examples{
trace <- MigrationDetectR::example_trace
# Detect segments
segments <-
  detect_segments(
      locs = trace$location,
      times = trace$timestamp,
      param_min_days = 3,
      param_prop_days = 0.06,
      param_window_size_days = 7)
 nrow(segments) # check the number of detected segments

 migrations <-
 identify_migrations(
  segs = segments$segments,
  locs = segments$locs,
  min_res_length = 90,
  occurrence_locs = trace$location,
  occurrence_times = trace$timestamp
  )
  nrow(migrations) # check the number of identified migrations
  head(migrations) # check the detected migrations
}
\references{
Chi, Guanghua, Fengyang Lin, Guangqing Chi, and Joshua Blumenstock. 2020. “A General Approach to Detecting Migration Events in Digital Trace Data.” Edited by Song Gao. PLOS ONE 15 (10): e0239408. https://doi.org/10.1371/journal.pone.0239408.
}
\author{
Johannes Mast \email{Johannes.Mast@dlr.de}, based on the algorithm by Guanghua Chi \email{guanghua@berkeley.edu}
}
