% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_genome_coverage}
\alias{plot_genome_coverage}
\title{plot_genome_coverage}
\usage{
plot_genome_coverage(biomart_file, path_fasta, chr_name, heteroplasmy_matrix)
}
\arguments{
\item{biomart_file}{Character string with full path to the txt file
downloaded from BioMart \url{https://m.ensembl.org/info/data/biomart/index.html} . It must have
the following five columns:Gene.stable.ID, Gene.name, Gene.start..bp.,
Gene.end..bp., Chromosome.scaffold.name}

\item{path_fasta}{Character string with full path to the fasta file of the
genomic region of interest. It should be the same file used in
\emph{get_raw_counts_allele}.}

\item{chr_name}{Character specifying the name of the chromosome of interest.
It must be one of the names in the \emph{Chromosome.scaffold.name} column
from the \emph{biomart_file}.}

\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}
}
\value{
KaryoPlot object as returned by \emph{plotKaryotype} function from package \emph{karyoploteR}.
}
\description{
plot_genome_coverage
}
\seealso{
\url{http://bioconductor.org/packages/release/bioc/html/karyoploteR.html}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
