% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtureFineOptim.R
\name{mixtureFineOptim}
\alias{mixtureFineOptim}
\title{Performs a restrict interval optimization}
\usage{
mixtureFineOptim(
  functions,
  desirabilityModel,
  startPoint,
  step = 0.001,
  alpha = 0.02,
  verbose = TRUE
)
}
\arguments{
\item{functions}{An array of functions}

\item{desirabilityModel}{A desirability \code{overallD} model}

\item{startPoint}{An array with the references (mid-points) for the optimization}

\item{step}{The ammount of each increment in the optimization}

\item{alpha}{Defines the range of the seach, as \code{startPoint} +- \code{alpha} for each \code{x} value}

\item{verbose}{Defines if the user should be updated with the processing status (percentages)}
}
\value{
A list containg the data regarding the maximum desirability found
}
\description{
This function performs an optimization testing within an interval defined
by the user using starting points and an alpha value. Since it is designed
for more accurate searching, it does not allow the generation of the
data frame for plotting.
}
\examples{
library(MixOptim)
dados <- read.table(header = TRUE, dec = ",", sep = "\t", text = "
x1	x2	x3	R1	R2	R3
1	0	0	0,76	8	5
1	0	0	0,75	8	5
0,5	0,5	0	1,4	7	7,5
0,5	0	0,5	0,55	8	10
0	1	0	4,1	4	10
0	1	0	4,4	4	10
0	0,5	0,5	0,9	7	12,5
0	0	1	0,42	9	15
0	0	1	0,4	10	15
0,6667	0,1667	0,1667	0,8	7	7,5
0,1667	0,6667	0,1667	1,7	7	10
0,1667	0,1667	0,6667	0,55	8	12,5
0,3333	0,3333	0,3333	0,8	8	10")

lm1 <- lm(data = dados, R1 ~ -1 + x1 + x2 + x3 + x1:x2 + x1:x3 + x2:x3)
summary(lm1)
flm1 <- function(x) 0.7678*x[1] + 4.2083*x[2] + 0.4274*x[3] - 4.3273*x[1]*x[2] +
      0.3070*x[1]*x[3] - 5.6101*x[2]*x[3]
lm2 <- lm(data = dados, R2 ~ -1 + x1 + x2 + x3)
summary(lm2)
flm2 <- function(x) 7.9742*x[1] + 4.5742*x[2] + 9.3742*x[3]
lm3 <- lm(data = dados, R3 ~ -1 + x1 + x2 + x3)
summary(lm3)
flm3 <- function(x) 4.9998461*x[1] + 9.9998461*x[2] + 14.9998461*x[3]

funcoes2 <- c(flm1, flm2, flm3)
des1<-dTarget(0.5, 0.6, 0.7)
des2<-dMax(8, max(dados$R2))
des3<-dMin(5, 10)
finalD<-dOverall(des1, des2, des3)

# code commented due to process time requirement
#teste <- mixtureOptim(funcoes2, finalD, 3, step = 0.01, plot = TRUE)
#desirabilityPlot(funcoes2, teste$plotData, teste$bestComposition,
#   list(des1, des2, des3), c("max", "max", "min"))

#teste2 <- mixtureFineOptim(funcoes2, finalD, teste$bestComposition, step = 0.0001)
#desirabilityPlot(funcoes2, teste$plotData, teste2$bestComposition,
#   list(des1, des2, des3), c("max", "max", "min"))
}
