# Clean environment and load libraries
rm(list = ls())  # Clear environment to avoid conflicts

# Source files
library(MixStable)
library(ggplot2)

# 🎲 Generate data
set.seed(123)
X <- rnorm(300)
u_vals <- seq(-10, 10, length.out = 200)

# 🔍 Compute ECF using recursive method
ecf_result <- ecf_fn(X, u_vals, method = "recursive")
yr <- ecf_result$magnitude

# 🔍 Compute ECF using kernel method
ecf_result1 <- ecf_fn(X, u_vals, method = "kernel")
yr1 <- ecf_result1$magnitude

# 📊 Plot kernel-smoothed ECF
df_plot1 <- data.frame(u = u_vals, magnitude = yr1)

p1 <- ggplot(df_plot1, aes(x = u, y = magnitude)) +
  geom_line(color = "blue") +
  labs(
    title = "Empirical Characteristic Function (Kernel Smoothed)",
    x = "u (frequency)",
    y = "|ECF(u)|"
  ) +
  theme_minimal()

# 📊 Plot recursive-smoothed ECF
df_plot <- data.frame(u = u_vals, magnitude = yr)

p <- ggplot(df_plot, aes(x = u, y = magnitude)) +
  geom_line(color = "red") +
  labs(
    title = "Empirical Characteristic Function (Recursive Smoothed)",
    x = "u (frequency)",
    y = "|ECF(u)|"
  ) +
  theme_minimal()

# Show plots
print(p1)
print(p)

# Save the plots
ggsave("ecf_kernel_plot.png", p1, width = 10, height = 5, dpi = 300)
ggsave("ecf_recursive_plot.png", p, width = 10, height = 5, dpi = 300)
