% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.time.point.R
\name{set.time.point}
\alias{set.time.point}
\title{Set time point}
\usage{
set.time.point(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  time.point = 0
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{time.point}{Input value for the time point (time the cohort of the individual was generated) (default: 0)}
}
\value{
Population-List with newly entered time points
}
\description{
Function to set time point of birth for individuals
}
\examples{
data(ex_pop)
population <- set.time.point(ex_pop, database=cbind(1,1), time.point = 2)
}
