% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLGM.R
\name{runLGM}
\alias{runLGM}
\title{Run Latent Growth Models (LGM) and replicate the best loglikelihood value (LL)}
\usage{
runLGM(lgm_object, wd)
}
\arguments{
\item{lgm_object}{An \code{mplusObject} with predefined random starting values (\code{STARTS}) in the ANALYSIS section.}

\item{wd}{A character string specifying the directory where the results folder will be created for saving the Mplus input, output, and data files.
Default is the current working directory.}
}
\value{
A list of class \code{mplusObject} including results for the replicated model, alongside with :
\itemize{
\item - The Mplus input and data files used for the model.
\item - The output files generated by Mplus.
\item - The data results files saved by Mplus.
}
}
\description{
Run iterations of an LGM, doubling the number of starting values
until the best LL value has replicated at least twice, both within and between models.
}
\details{
The \code{runLGM} function run iterations of an LGM in Mplus while gradually increasing the number of random starting values used to optimize the loglikelihood.
This approach aims to prevent estimation issues related to local maxima, which can result in selecting the inappropriate model during class enumeration.
The function works as follows:
\itemize{
\item 1. Estimate the model using the predefined number of random starting values.
\item 2. Rerun the model with double the number of starting values.
\item 3. Continue until the best LL value is successfully replicated both within the model and between 2 consecutive model run,
or the maximum number of allowed starting values is reached. By default the maximum number of allowed starting values
is set 2 times the number of initial starting values raised to the power of 5.
\item 4. Return the \code{mplusObject} from the replicated model.
}

This function builds upon the capabilities of the \code{\link[MplusAutomation]{mplusModeler}} function
from the MplusAutomation package.
}
\examples{
\donttest{
# Example usage:
GBTM_model <-  runLGM(
  lgm_object = GBTM_object,
  wd = file.path("Results", "Trajectories"))
}
}
\seealso{
\code{\link[MplusAutomation]{mplusModeler}} for running, and reading an mplusObject.
\code{\link{LGMobject}} for creating the mplusObject for a latent growth model.
}
