% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkcrit.r
\name{checkcrit}
\alias{checkcrit}
\title{Check critical values}
\usage{
checkcrit(
  scrit = qnorm(c(0.01, 0.02, 0.025)),
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1
)
}
\arguments{
\item{scrit}{Numeric vector of critical values.}

\item{salpha}{Numeric vector of cumulative alpha levels.}

\item{smatrix}{General correlation matrix.}

\item{sided}{Integer vector indicating the side of the test:
\itemize{
\item \code{-1}: Reject if test statistic is smaller than or equal to the critical value (one-sided)
\item \code{1}: Reject if test statistic is greater or equal to the critical value (one-sided)
\item \code{0}: Reject if the absolute value of the test statistic is greater than the critical value (two-sided)
}}
}
\value{
List with:
\itemize{
\item \code{crit.value}: Critical values
\item \code{salpha}: Cumulative alpha levels passed to \code{salpha} argument
}
}
\description{
\code{checkcrit()} is a helper function that checks if the critical values
are valid.
}
\examples{
checkcrit(
  scrit = qnorm(c(0.01, 0.02, 0.025)),
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1
)
}
\author{
Xiaodong Luo
}
\concept{critical values}
\concept{efficacy boundary}
\concept{group-sequential}
