% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_mean_methods.R
\name{print.NAVAE_CI_Mean}
\alias{print.NAVAE_CI_Mean}
\alias{as.data.frame.NAVAE_CI_Mean}
\title{Print and coerce a NAVAE_CI_Mean object}
\usage{
\method{print}{NAVAE_CI_Mean}(x, verbose = 0, ...)

\method{as.data.frame}{NAVAE_CI_Mean}(x, ...)
}
\arguments{
\item{x}{the object}

\item{verbose}{if zero, only basic printing is done. Higher values corresponds
to more detailed output.}

\item{...}{other arguments, currently ignored.}
}
\value{
\code{print.Navae_ci_ols} prints information about \code{x} and returns it
invisibly.

\code{as.data.frame} returns a \code{data.frame} with 2 rows.
}
\description{
Print and coerce a NAVAE_CI_Mean object
}
\examples{
n = 10000
x = rexp(n, 1)
myCI = Navae_ci_mean(x, bound_K = 9, alpha = 0.2)

print(myCI)
as.data.frame(myCI)


}
\references{
Derumigny, A., Girard, L., & Guyonvarch, Y. (2025).
Can we have it all?
Non-asymptotically valid and asymptotically exact confidence intervals
for expectations and linear regressions.
ArXiv preprint, \doi{10.48550/arXiv.2507.16776}
}
\seealso{
The function to generate such objects \code{\link{Navae_ci_mean}}.

The corresponding methods for the regression (OLS):
\code{\link{print.NAVAE_CI_OLS}} and
\code{\link{as.data.frame.NAVAE_CI_OLS}}.
}
