% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimNCSCop.R
\name{SimNCSCop}
\alias{SimNCSCop}
\title{Simulation of a bivariate non-central squared copula}
\usage{
SimNCSCop(family, n, param, DoF = NULL)
}
\arguments{
\item{family}{'Gaussian' , 't' , 'Clayton' , 'Frank' , 'Gumbel'.}

\item{n}{number of simulated vectors.}

\item{param}{c(a1,a2,tau)  where  a1,a2  are the non-negative non-centrality}

\item{DoF}{degrees of freedom of the Student copula (if needed).}
}
\value{
\item{U}{Simulated Data}
}
\description{
This function simulates observations a bivariate non-central squared copula model.
}
\examples{
param <- c(0.8, 2.5, 0.7) ;
U <- SimNCSCop('Clayton', 250, param)

}
\author{
Bouchra R. Nasri, August 14, 2019
}
