% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadExt.R
\name{NMreadExt}
\alias{NMreadExt}
\title{Read information from Nonmem ext files}
\usage{
NMreadExt(
  file,
  return,
  as.fun,
  modelname,
  col.model,
  auto.ext,
  tableno = "max",
  file.ext,
  slow
)
}
\arguments{
\item{file}{Path to the ext file}

\item{return}{The .ext file contains both final parameter
estimates and iterations of the estimates. If
\code{return="pars"} (default) the final estimates are
returned in addition to what other parameter-level information
is found, like FIX, sd etc. as columns. If
\code{return="iterations"}, the iterations are returned
(including objective function value). If \code{return="obj"}
objective function value at final estimate is returned. If
\code{return="all"}, all er returned, though in separate
data.frames compiled in a list.}

\item{as.fun}{The default is to return data as a \code{data.frame}. Pass
a function in as.fun to convert to
something else. If `data.table`s are wanted, use
`as.fun="data.table"`. The default can be configured using
\code{NMdataConf()}.}

\item{modelname}{See `?NMscanData`}

\item{col.model}{See `?NMscanData`}

\item{auto.ext}{If `TRUE` (default) the extension will
automatically be modified using \code{NMdataConf()$file.ext}. This
means `file` can be the path to an input or output control
stream, and \code{NMreadExt} will still read the `.ext` file.}

\item{tableno}{In case the ext file contains multiple tables, this
    argument controls which one to choose. The options are
    \itemize{

\item "max" (default) Pick the table with the highest table
number. This typically means the results from the last
`$ESTIMATION` step are used.

\item "min" Pick results from the first table available.

\item "all" Keep all results. The tables can be distinguished by
the \code{tableno} column.

\item an integer greater than 0, in which case the table with this
table number will be picked.  }}

\item{file.ext}{Deprecated. Please use \code{file} instead.}

\item{slow}{Use a slow but more robust method to read tables? If
missing or `NULL`, the fast method will be tried first, and if
any issues are seen, the method will switch to `slow=TRUE`. If
`FALSE`,it will also switch in case of issues, but a warning is
issued. In other words, it should be safe to not use this
argument.}
}
\value{
If \code{return="all"}, a list with a final parameter
    table and a table of the iterations. If \code{return="pars"},
    only the parameter table, and if \code{return="iterations"}
    only the iterations table. If you need both, it may be more
    efficient to only read the file once and use
    \code{return="all"}. Often, only one of the two are needed,
    and it more convenient to just extract one.
}
\description{
Read information from Nonmem ext files
}
\details{
The parameter table returned if \code{return="pars"} or
    \code{return="all"} will contain columns based on the Nonmem
    7.5 manual. It defines codes for different parameter-level
    values. They are:

\code{-1e+09: se}
\code{-1000000002: eigCor}
\code{-1000000003: cond}
\code{-1000000004: stdDevCor}
\code{-1000000005: seStdDevCor}
\code{-1000000006: FIX}
\code{-1000000007: termStat}
\code{-1000000008: partLik}

The parameter name is in the \code{parameter} column. The
"parameter type", like "THETA", "OMEGA", "SIGMA" are available in
the \code{par.type} column. Counters are available in \code{i} and
\code{j} columns. \code{j} will be \code{NA} for
\code{par.type=="THETA"}

The objective function value is included as a parameter.

Notice that in case multiple tables are available in the `ext`
file, the column names are taken from the first table. E.g., in
case of SAEM/IMP estimation, the objective function values will be
in the \code{SAEMOBJ} column, even for the IMP step. This may change in
the future.
}
