#' Calculate Internal Efficiency (IE)
#' @description
#' The fraction of plant tissue N that is contained in the yield component.
#' Formula: IE = YieldNF / PlantNf
#' @param YieldNF A numeric vector for yield N in fertilized conditions.
#' @param PlantNf A numeric vector for plant N in fertilized conditions.
#' @return A numeric vector of IE values.
#' @examples
#' YieldNF <- c(80, 90, 100)
#' PlantNf <- c(3.5, 4.0, 4.2)
#' IE(YieldNF, PlantNf)
#' @export
IE <- function(YieldNF, PlantNf) {
  # Error handling: lengths should match
  if(length(YieldNF) != length(PlantNf)) {
    warning("YieldNF and PlantNf vectors have different lengths. Results may be mismatched.")
  }
  return(YieldNF / PlantNf)
}