#' Calculate Nitrogen Productivity (NP)
#' @description
#' The ratio of the relative growth rate to the concentration of N in plant tissues.
#' Formula: NP = GR / PlantN
#' @param GR A numeric vector for Plant relative growth rate.
#' @param PlantN A numeric vector for plant N concentration.
#' @return A numeric vector of NP values.
#' @examples
#' GR <- c(0.5, 0.6)
#' PlantN <- c(2.0, 2.2)
#' NP(GR, PlantN)
#' @export
NP <- function(GR, PlantN) {
  return(GR / PlantN)
}