\name{fibers69}
\alias{fibers69}
\title{Tensile Strength of 69 Carbon Fibers at 20 mm Gauge Length}

\description{
Measurements of tensile strength (in gigapascals, GPa) for 69 carbon fibers
tested under tension at a gauge length of 20 mm. These data were originally
reported by Bader and Priest (1982) in their study of fibre and bundle strength
in hybrid composites.
}

\usage{
fibers69
}

\format{
A numeric vector of length 69 containing tensile strength values (in GPa).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 69 tensile strength measurements (in gigapascals)
corresponding to individual carbon fiber specimens tested at a gauge length
of 20 mm. Each value represents the breaking strength of a single fiber.
The dataset is commonly used for statistical analysis of strength
distributions, reliability modeling, and comparative studies of gauge-length
effects in composite materials.
}

\details{
This dataset has been widely used in composite-material and reliability
studies, particularly for modeling strength distributions of carbon fibers.  
The original experiment measured the tensile strength of individual fibers at
a gauge length of 20 mm, providing insight into the statistical behavior of
fiber strength under tension.
}

\references{
Bader, M. G., & Priest, A. M. (1982). Statistical aspects of fibre and bundle
strength in hybrid composites.  
\emph{Progress in Science and Engineering of Composites}, 1129--1136.
}

\examples{
data(fibers69)

summary(fibers69)

hist(
  fibers69,
  main = "Tensile Strength of Carbon Fibers (20 mm Gauge Length)",
  xlab = "Strength (GPa)"
)
}

\keyword{datasets}
