\name{continue_OCN}
\alias{continue_OCN}
\title{Perform OCN Search Algorithm on an Existing OCN}
\usage{
continue_OCN(OCN,nNewIter, coolingRate=NULL, initialNoCoolingPhase=0,
 displayUpdates=1, showIntermediatePlots=FALSE, thrADraw=NULL,
 easyDraw=NULL, nUpdates=50)
}
\arguments{
\item{OCN}{A \code{river} object (as generated by \code{\link{create_OCN}}).}

\item{nNewIter}{Number of iterations that the OCN search algorithm performs.}

\item{coolingRate}{Parameter of the function used to describe the temperature of the simulated annealing algorithm. See \code{\link{create_OCN}}. If \code{NULL}, it is set equal to the last element of \code{OCN$coolingRate}.}

\item{initialNoCoolingPhase}{Parameter of the function used to describe the temperature of the simulated annealing algorithm. See \code{\link{create_OCN}}.}

\item{nUpdates}{Number of updates given during the OCN search process (only effective if \code{any(displayUpdates,showIntermediatePlots)=TRUE}.).}

\item{showIntermediatePlots}{If \code{TRUE}, the OCN plot is updated \code{nUpdates} times during the OCN search process.
Note that, for large lattices, \code{showIntermediatePlots = TRUE} might slow down the search process considerably (especially when \code{easyDraw = FALSE}).}

\item{thrADraw}{Threshold drainage area value used to display the network (only effective when \code{showIntermediatePlots = TRUE}).}

\item{easyDraw}{Logical. If \code{TRUE}, the whole network is displayed (when \code{showIntermediatePlots = TRUE}), and pixels with drainage area lower than \code{thrADraw} are displayed in light gray. If \code{FALSE}, only pixels with drainage area greater or equal to \code{thrADraw} are displayed. Default is \code{FALSE} if \code{dimX*dimY <= 40000}, and \code{TRUE} otherwise. Note that setting \code{easyDraw = FALSE} for large networks might slow down the process considerably.}

\item{displayUpdates}{State if updates are printed on the console while the OCN search algorithm runs.
\describe{
\item{\code{0}}{No update is given.}
\item{\code{1}}{An estimate of duration is given (only if \code{dimX*dimY > 1000}, otherwise no update is given).}
\item{\code{2}}{Progress updates are given. The number of these is controlled by \code{nUpdates}}
}}
}
\value{
A \code{river} object analogous to the input \code{OCN}. Note that, unlike in \code{\link{create_OCN}}, \code{OCN$coolingRate} and \code{OCN$initialNoCoolingPhase} are now vectors (of length equal to the number of times \code{\link{continue_OCN}} has been performed on the same OCN, plus one) that store the full sequence of \code{coolingRate}, \code{initialNoCoolingPhase} used to generate the OCN. Additionally, the vector \code{OCN$nIterSequence} is provided, with entries equal to the number of iterations performed by each successive application of \code{\link{create_OCN}} or \code{\link{continue_OCN}}. It is \code{OCN$nIter = sum(OCN$nIterSequence)}.
}
\description{
Function that performs the OCN search algorithm on an existing OCN.
}
\examples{
set.seed(1)
OCN_a <- create_OCN(20, 20, nIter = 10000)
set.seed(1)
OCN_b <- create_OCN(20, 20, nIter = 5000)
OCN_b <- continue_OCN(OCN_b, nNewIter = 5000)

old.par <- par(no.readonly = TRUE)
par(mfrow=c(1,2))
draw_simple_OCN(OCN_a)
draw_simple_OCN(OCN_b) # the two OCNs are equal
par(old.par)
}


