% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{var.exp}
\alias{var.exp}
\title{explanatory power of factors}
\usage{
var.exp(Y, k = 2, type = "proj", kmax = 4, plot = 0)
}
\arguments{
\item{Y}{data, a \eqn{T\times p1\times p2} array.}

\item{k}{a positive integer indicating the number of factors investigated, should be
smaller than p1.}

\item{type}{indicates how to calculate the sample covariance. "flat" for the
flat version, while others for the projected version.}

\item{kmax}{a positive integer smaller than p2, indicating the
upper bound for the factor numbers, and the dimension of projection matrix.}

\item{plot}{a logical value. When \emph{plot=1}, a figure of the
cumulative explanatory power will be plotted, with x axis being the number of
factors, and y axis being the cumulative explained variance.}
}
\value{
a vector with k entries, corresponding to the cumulative explanatory power
of the leading k factors.
}
\description{
This function calculates the cumulative explanatory power of the
leading  row factors, in terms of the explained variance, under a
two-way factor structure.
}
\examples{
k1=3
k2=3
Sample_T=100
p1=40
p2=20

Y=gen.data(Sample_T,p1,p2,k1,k2,tau=0.5,change=0)
var.exp(Y,k=5,plot=1)

}
