% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_C.R
\name{update_C}
\alias{update_C}
\title{Update sub-matrix C}
\usage{
update_C(W,update_R_list,lambda=0.2,rho=1.1)
}
\arguments{
\item{W}{The matrix to be factorized}

\item{update_R_list}{A list containing the updated results in this iteration after running the function update_R}

\item{lambda}{A parameter to set the relative weight of the sparsity constraints}

\item{rho}{A parameter used in the augmented lagrange multiplier method}
}
\value{
A list the same as update_R_list with the matrix C updated
}
\description{
Update sub-matrix C
}
\examples{

W <- simu_data_generation()
init_list <- initialization(W,k=5,l=4)
update_L_list <- update_L(W,init_list)
update_B_list <- update_B(W,update_L_list)
update_R_list <- update_R(W,update_B_list)
update_C_list <- update_C(W,update_R_list,lambda=0.2,rho=1.1)
}
\author{
Xiaoyao Yin
}
