% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Pxy}
\alias{Pxy}
\title{A function to compute the mean proximity between 
persons of different groups (Pxy)}
\usage{
Pxy(x, d = NULL, fdist = 'e', distin = 'm',  distout = 'm', diagval = '0', 
beta = 1, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{d}{a matrix of the distances between spatial unit centroids}

\item{fdist}{the method used for distance interaction matrix: 
e' for inverse exponential function (by default) and 'l' for linear.}

\item{distin}{input metric conversion, based on  \pkg{bink} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{output metric conversion, based on  \pkg{bink} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{diagval}{when providing a spatial object or a shape file, 
the user has the choice of the spatial matrix diagonal definition: 
diagval = '0' (by default) for an null diagonal and diagval = 'a' 
to compute the diagonal as 0.6 * square root (spatial/organizational unitsarea) (White, 1983)}

\item{beta}{distance decay parameter}

\item{spatobj}{a spatial object (SpatialPolygonsDataFrame) with 
geographic information}

\item{folder}{a character vector with the folder (directory) 
name indicating where the shapefile is located on the drive}

\item{shape}{a character vector with the name of the shapefile 
(without the .shp extension).}
}
\value{
A matrix containing the Pxy index values for each pair of groups
}
\description{
Mean proximity, Pxy, computes the mean distance 
between the members of different groups.The function can be used in 
two ways: to provide a distance matrix or a external geographic 
information source (spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
ar<-area(segdata)
dist <- distance(segdata)
diag(dist)<-sqrt(ar) * 0.6
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

Pxy(x, spatobj = segdata)

Pxy(x, folder = foldername, shape = shapename, fdist = 'l') 

Pxy(x, spatobj = segdata, diagval ='a')

Pxy(x, d = dist, fdist = 'e')

}
\references{
White M. J. (1983) \emph{The Measurement of 
Spatial Segregation}. American Journal of Sociology, 88, p. 1008-1019
}
\seealso{
Proximity measures: \code{\link{Pxx}}, 
\code{\link{Poo}},  \code{\link{SP}}

Clustering Indices: 
\code{\link{ACL}}, \code{\link{RCL}}
}
