% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getBinaryCaseSeries}
\alias{getBinaryCaseSeries}
\title{A function to extract case series characterization results}
\usage{
getBinaryCaseSeries(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetId = NULL,
  outcomeId = NULL,
  databaseIds = NULL,
  riskWindowStart = NULL,
  riskWindowEnd = NULL,
  startAnchor = NULL,
  endAnchor = NULL,
  conceptIds = NULL,
  minVal = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetId}{An integer corresponding to the target cohort ID}

\item{outcomeId}{Am integer corresponding to the outcome cohort ID}

\item{databaseIds}{(optional) One or more unique identifiers for the databases}

\item{riskWindowStart}{(optional) A riskWindowStart to restrict to}

\item{riskWindowEnd}{(optional) A riskWindowEnd to restrict to}

\item{startAnchor}{(optional) A startAnchor to restrict to}

\item{endAnchor}{(optional) An endAnchor to restrict to}

\item{conceptIds}{(optional) An conceptIds to restrict to}

\item{minVal}{(optional) the minimum averageVal to extract}
}
\value{
A data.frame with the characterization case series results
}
\description{
A function to extract case series characterization results
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cs <- getBinaryCaseSeries(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetId = 1, 
  outcomeId = 3
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
