\name{tcctomat}
\title{Create or add to a time-constant covariate (tccov) object}
\usage{
tcctomat(ccov, names=NULL, oldtccov=NULL)
}
\alias{tcctomat}
\alias{print.tccov}
\alias{covind}
\arguments{
\item{ccov}{A vector or matrix containing time-constant baseline
covariates with one row per individual or a model formula using
vectors of the same size.}
\item{names}{The names of the covariates (if the matrix does not have
column names).}
\item{oldtccov}{An object of class, tccov, to which ccov is to be
added.}
}
\description{
\code{tcctomat} transforms a vector or matrix containing time-constant
baseline covariates or a model formula into an object of class, tccov.

Such objects can be printed.

To obtain the indexing to expand time-constant covariates to the size
of a repeated measurements response, use \code{covind}.
}
\value{
Returns an object of class, tccov, containing one matrix for the
covariates (z$ccov) with one row per individual, a list of their
names, and possibly the model formula (z$linear).
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gettvc}},
\code{\link{kalcount}}, \code{\link{kalseries}}, \code{\link{nbkal}},
\code{\link{read.list}}, \code{\link{restovec}}, \code{\link{tcctomat}}.
}
