% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_clean.R
\name{export_clean}
\alias{export_clean}
\title{Export Cleaned Omics Data}
\usage{
export_clean(data, file_path)
}
\arguments{
\item{data}{A cleaned omics data frame or matrix.}

\item{file_path}{Path to the file where the data will be saved.}
}
\value{
None. A file is written to disk.
}
\description{
Saves a cleaned omics dataset to a CSV file.
}
\examples{
\donttest{
# Create sample data
data <- matrix(rnorm(100), nrow = 10)
cleaned_data <- as.data.frame(data)

# Save to a temporary location (CRAN policy compliant)
temp_file <- tempfile(fileext = ".csv")
export_clean(cleaned_data, temp_file)
}

}
