% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpeNoise.R
\name{PlotNoiseTimeHistory}
\alias{PlotNoiseTimeHistory}
\title{Plot time history of noise misure with marker and running Leq}
\usage{
PlotNoiseTimeHistory(
  df = NULL,
  variable = NULL,
  filemarks = NULL,
  escl_marks = NULL,
  mp,
  y_lim = c(20, 80)
)
}
\arguments{
\item{df}{is a dataframe with date, leq and markers}

\item{variable}{is a string name of column you want plot}

\item{filemarks}{is a dataframe with date and markers}

\item{escl_marks}{is mark that you want esclude in plot}

\item{mp}{is a name of misure point}

\item{y_lim}{y axes range}
}
\value{
ggplot object
}
\description{
Returns a time history plot
}
\examples{
#data(P1FA)
#data(markers)

PlotNoiseTimeHistory(df = P1FA, variable = "LAeq", mp = "P1FA", y_lim = c(40, 65))

PlotNoiseTimeHistory(df = P1FA, variable = "LAeq", mp = "P1FA",
                     filemarks = markers, y_lim = c(40, 65))

PlotNoiseTimeHistory(df = P1FA, variable = "LAeq", mp = "P1FA", escl_marks = "escludi",
                     y_lim = c(40, 65))

}
\author{
Pasquale Scordino \email{p.scordino@arpa.piemonte.it}

Simone Sperotto \email{s.sperotto@arpa.piemonte.it}
}
