% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptRegionTps.R
\name{OptRegionTps}
\alias{OptRegionTps}
\title{Confidence region for optima of Thin Plate Spline Models (2 regressors)}
\usage{
OptRegionTps(
  X,
  y,
  lambda = 0.04,
  nosim = 1000,
  alpha = 0.05,
  LB,
  UB,
  triangularRegion = FALSE,
  vertex1 = NULL,
  vertex2 = NULL,
  maximization = TRUE,
  xlab = "Protein eaten, mg",
  ylab = "Carbohydrate eaten, mg",
  outputPDFFile = "CRplot.pdf",
  outputOptimaFile = "Optima.txt"
)
}
\arguments{
\item{X}{n*2 matrix with the values of the 2 regressors (experimental factors)
in the n observations. Note: this can have replicates.
They will be eliminated by the program and the corresponding
y-values averaged}

\item{y}{n*1 vector of response value observations, in the same order corresponding
to the rows of X}

\item{lambda}{penalization parameter (larger values implies more smoothing).
Default is 0.04}

\item{nosim}{number of simulations (default = 200)}

\item{alpha}{confidence level (0 < alpha < 1; default = 0.05)}

\item{LB}{vector of lower bounds for x (2*1 vector) above which the maximum is sought}

\item{UB}{vector of upper bounds for x (2*1 vector) below which the maximum is sought}

\item{triangularRegion}{logical: if TRUE it will constrain the maximum points to lie
inside a triangle defined by the coordinates (0,0), and those
in 'vertex1', and 'vertex2', see below (in addition to being
constrained to lie inside the region defined by LB and UB).
NOTE: use TRUE when the treatments form a triangular
experimental region in shape. If FALSE, maxima will only be
constrained to lie inside the rectangular region defined by
LB and UB. Default is FALSE.}

\item{vertex1}{2 times 1 vector with coordinates defining one of the 3 vertices of
a triangular region. Must be provided if triangularRegion is TRUE
(NOTE: vertices numbered clockwise)}

\item{vertex2}{2 times 1 vector with coordinates defining a second vertex of a
triangular region (third vertex is (0,0) by default). Must be provided
if triangularRegion is TRUE (NOTE: vertices numbered clockwise)}

\item{maximization}{logical: if TRUE (default) it maximizes it FALSE it minimizes}

\item{xlab}{text label for x axis in confidence region plot
(default: "Protein eaten (mg)")}

\item{ylab}{text label for y axis in confidence region plot
(default: "Carbohydrates eaten (mg)")}

\item{outputPDFFile}{name of the PDF file where the CR plot is saved
(default: "CR_plot.pdf")}

\item{outputOptimaFile}{name of the text file containing the coordinates of all
the optima found (same information as in output vector xin, see below)}
}
\value{
Upon completion, a PDF file containing the CR plot with name as set in
        ouputPDFFile is created and a text file with all optima in the CR is created too.
        Also, the function returns a list containing
        the following 2 components:
        \describe{
          \item{meanPoint}{a 2x1 vector with the coordinates of the mean optimum
                             point (displayed as a red dot in the CR plot in output
                             PDF file)}
          \item{xin}{an mx2 matrix with the x,y coordinates of all simulated
                       points that belong to the confidence region (dim(m) is
                       (1-alpha)*nosim)}
        }
}
\description{
Computes and displays an approximated (1 - alpha)*100% confidence region (CR) for
the linear-constrained maximum of a penalized Thin Plate Spline (TPS) model
in 2 controllable factors
\insertCite{DelCastilloCR}{OptimaRegion}.
Generates a PDF file with a graph displaying the CR.
Grey region on output plot is the approximate CR. The mean coordinates (centroid)
of the optima is shown as a red point.
}
\details{
This program approximates the confidence region (CR) of the location of the optimum
of a Thin Plate Spline (TPS) in 2 regressors x constrained inside  a rectangular
region defined by LB and UB. If triangularRegion=TRUE it will also contrain the
optimum to lie inside the experimental region assumed to be well approximated by
a triangle. The CR is generated pointwise by bootstrapping the residuals of a TPS fit
to the given (X,y) data, refitting Tps models, and solving the corresponding
constrained maximization (or minimization) problems. The confidence region is
approximated by the convex hull of all the optimal solutions found. The CR
computation is based on the "CS" bootstrapping approach for building a confidence set
of a parametric function described in
\insertCite{WoutersenHam2013;textual}{OptimaRegion}.
This version of the program
uses nonparametric bootstrapping confidence regions to get the Confidence region of
the Tps parameters,using the notion of data depth according to
\insertCite{yeh1997balanced;textual}{OptimaRegion}.
Hence, this version does not rely on the normality assumption of the data.
The TPS models are fit using the "fields" R package
\insertCite{fieldsPackage}{OptimaRegion}
and its "Tps" function.
}
\section{Author(s)}{

Enrique del Castillo \email{exd13@psu.edu},
Peng Chen \email{pfc5098@psu.edu},
Adam Meyers \email{akm5733@psu.edu},
John Hunt \email{J.Hunt@westernsydney.edu.au} and
James Rapkin \email{jr297@exeter.ac.uk}.
}

\examples{
\dontrun{
# Example 1: randomly generated 2-variable response surface data
X <- cbind(runif(100, -2, 2), runif(100, -2, 2))
y <- as.matrix(72 - 11.78 * X[, 1] + 0.74 * X[, 2] - 7.25 * X[, 1]^2 -
  7.55 * X[, 2]^2 - 4.85 * X[, 1] * X[, 2] + rnorm(100, 0, 8))
# Find a 95 percent confidence region for the maximum of a Thin Plate Spline
# model fitted to these data
out <- OptRegionTps(
  X = X, y = y, nosim = 200, LB = c(-2, -2), UB = c(2, 2),
  xlab = "X1", ylab = "X2"
)

# Example 2: a mixture-amount experiment in two components (Drug dataset) with
# non-normal data. Note triangular experimental region. Resulting 95p confidence
# region of the maxima of a TPS model has area > 0. Contrast with region for
# quadratic polynomial model. Note: 500 bootstrap iterations may take a few minutes.
out <- OptRegionTps(
  X = Drug[, 1:2], y = Drug[, 3], nosim = 500, lambda = 0.05, LB = c(0, 0),
  UB = c(0.08, 11), xlab = "Component 1 (mg.)", ylab = "Component 2 (mg.)",
  triangularRegion = TRUE, vertex1 = c(0.02, 11), vertex2 = c(0.08, 1.8),
  outputPDFFile = "Mixture_plot.pdf"
)
}
}
\references{
{
 \insertAllCited{}
}
}
