% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifMissing.R
\name{ifMissing}
\alias{ifMissing}
\title{Take Measures in Case of Nonexisting Target Files}
\usage{
ifMissing(ofl, fun0 = terra::rast, fun1 = terra::writeRaster, arg1, ...)
}
\arguments{
\item{ofl}{Target file name as \code{character}.}

\item{fun0}{If 'ofl' exists, \code{function} to be applied to it. Defaults to
\code{\link[terra:rast]{terra::rast()}}).}

\item{fun1}{If 'ofl' does not exist, \code{function} used to create it. Defaults
to \code{\link[terra:writeRaster]{terra::writeRaster()}}).}

\item{arg1}{Argument in 'fun1' (as \code{character}) that corresponds to 'ofl',
e.g. 'filename' in \code{\link[terra:writeRaster]{terra::writeRaster()}} or 'file' in
\code{\link[utils:write.table]{utils::write.table()}}. If missing (default), the target file name passed
to 'fun1' needs to be explicitly included via '...'.}

\item{...}{Additional arguments passed to 'fun0' and 'fun1'.}
}
\value{
If 'ofl' has already existed, the contents of 'ofl' derived from 'fun0'; else
the output resultant from 'fun1'.
}
\description{
If a target file already exists, it is simply being imported into R. However,
if the specified target file does not exist, it is first created by a
user-defined function and subsequently returned, thus rendering explicit
calls to \code{\link[=file.exists]{file.exists()}} unnecessary.
}
\examples{
# simply import existing file
logo <- system.file("ex/logo.tif", package = "terra")
s <- ifMissing(logo) 

# create nonexisting file and import it afterwards
logo2 <- file.path(tempdir(), "rlogo.tif")
s2 <- ifMissing(logo2, arg1 = "filename", x = s, datatype = "INT1U")

# this also works with text files and more sophisticated custom functions
fun = function(x, file = "", ...) {
  write.csv(x, file, ...)
  read.csv(file)
}

data(iris)
ofl <- file.path(tempdir(), "iris.csv")
iris2 <- ifMissing(ofl, fun1 = fun, x = iris, file = ofl, quote = FALSE, row.names = FALSE)

}
\seealso{
\code{\link[=file.exists]{file.exists()}}, \code{\link[=do.call]{do.call()}}.
}
\author{
Florian Detsch
}
