% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{standardized_mean_differences}
\alias{standardized_mean_differences}
\title{Calls C++ implementation to calculate standardized mean differences.}
\usage{
standardized_mean_differences(X, treat, omega, target = NULL)
}
\arguments{
\item{X}{Covariate matrix with N rows and p columns.}

\item{treat}{Binary treatment variable.}

\item{omega}{Outcome weights matrix with dimension number of weight vectors for which balancing should be checked
x number of training units.}

\item{target}{Optional matrix with dimension number of weight vectors for which balancing should be checked
x p indicating the target values the covariates should be balanced towards.
If NULL, average of X used as target of ATE.}
}
\value{
3D-array of dimension p x 6 x number of weight vectors for which balancing should be checked
where the second dimension provides the following quantities:
\itemize{
\item "Mean 0": The weighted control mean
\item "Mean 1": The weighted treated mean
\item "SMD balancing": Standardized mean differences for covariate balancing (Mean 1 - Mean 0) / sd(X)
\item "SMD targeting 0": Standardized mean difference to assess targeting of control (Mean 0 - target) / sd(X)
\item "SMD targeting 1": Standardized mean difference to assess targeting of treated (Mean 1 - target) / sd(X)
}
}
\description{
Calculates standardized mean differences between treated and controls and towards target means
for an outcome weights matrix with potentially many rows like for CATEs.
}
\references{
Rosenbaum, P. R., & Rubin, D. B. (1984). Reducing bias in observational studies using subclassification on the propensity score.
Journal of the American Statistical Association, 79 (387), 516–524.
}
