% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parents_ordering.R
\name{complete_and_check_orders}
\alias{complete_and_check_orders}
\title{Complete an order and check whether these are valid orders on parents sets}
\usage{
complete_and_check_orders(DAG, order_hash)
}
\arguments{
\item{DAG}{the DAG}

\item{order_hash}{the hashmaps of orders}
}
\value{
\code{NULL}. This function has only side-effects,
and modifies \code{order_hash}. It stops if the orders are not valid orders
on the parents sets.
}
\description{
Complete an order and check whether these are valid orders on parents sets
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

order_hash = r2r::hashmap()
try({complete_and_check_orders(DAG, order_hash)})
# Error because the order of the parents on "U3" should be specified.

order_hash[['U3']] = c("U1", "U2")
complete_and_check_orders(DAG, order_hash)
r2r::keys(order_hash)
# We obtain "U3" and "U4" because they both have parents

}
