% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{has_interfering_vstrucs}
\alias{has_interfering_vstrucs}
\title{Checks if graph has interfering v-structures}
\usage{
has_interfering_vstrucs(DAG, verbose = 0)
}
\arguments{
\item{DAG}{Directed Acyclic Graph}

\item{verbose}{if \code{verbose} is 0, do not print anything.
If \code{verbose} is positive, print the name of the first node at which the
interfering v-structure is found.}
}
\value{
\code{TRUE} if graph contains (at least) an interfering v-structure,
and \code{FALSE} if it does not contain any interfering v-structure.
}
\description{
Checks if graph has interfering v-structures
}
\examples{

DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

# There is one interfering v-structure
has_interfering_vstrucs(DAG, verbose = 1)

DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
# Now no interfering v-structure
has_interfering_vstrucs(DAG)

}
