% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLindleyROC.R
\name{PLindleyROC}
\alias{PLindleyROC}
\alias{dPLD}
\alias{pPLD}
\alias{qPLD}
\alias{rPLD}
\alias{r.pl_auc}
\alias{r.pl_index}
\alias{r.pl_graph}
\title{Receiver Operating Characteristic based on Power Lindley Distribution}
\usage{
dPLD(x, alpha, beta)

pPLD(x, alpha, beta)

qPLD(p, alpha, beta)

rPLD(n, alpha, beta)

r.pl_auc(
  x,
  y,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)

r.pl_index(
  x,
  y,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  init_index = 1,
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)

r.pl_graph(
  x,
  y,
  init_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  true_param = c(alpha1 = 1, beta1 = 1, alpha2 = 1, beta2 = 1),
  empirical = TRUE,
  method = c("MLE", "AD", "CvM", "LSE", "WLSE", "TRUE")
)
}
\arguments{
\item{x, y}{vector of quantiles.}

\item{alpha}{shape parameter.}

\item{beta}{scale parameter.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}

\item{init_param}{initial paremeter values for the estimation method.}

\item{true_param}{true parameter values.}

\item{method}{estimation method. The default value for the method is "MLE".}

\item{init_index}{initial index value for the optimization calculation.}

\item{empirical}{empirical must be TRUE or FALSE.}

\item{alpha1}{shape parameter of distribution of first sample.}

\item{beta1}{scale parameter of distribution of first sample.}

\item{alpha2}{shape parameter of distribution of second sample.}

\item{beta2}{scale parameter of distribution of second sample.}
}
\value{
\code{dPLD} gives the probability density function of Power
Lindley Distribution.

\code{pPLD} gives the cumulative density function of
Power Lindley Distribution.

\code{qPLD} gives the quantile function of
Power Lindley Distribution.

\code{rPLD} gives random numbers from Power Lindley Distribution.

\code{r.pl_auc} gives the Area Under the Curve (AUC) when the data
conforms to the Power Lindley Distribution.

\code{r.pl_index} gives index values when the data conforms to the
Power Lindley Distribution.

\code{r.pl_graph} gives the ROC curve when the data conforms to the
Power Lindley Distribution.
}
\description{
ROC curve analysis is performed assuming samples are from the
Power Lindley distribution. Specificity, sensitivity, area under the curve
and ROC curve are provided.
}
\details{
The probability density function (PDF) and cumulative distribution function
(CDF) are as follows:
\deqn{f\left( x;\boldsymbol{\theta }\right) =\frac{\alpha \beta ^{2}}{
\beta +1}\left( 1+x^{\alpha}
\right) x^{\alpha -1}\exp \left( -\beta x^{\alpha }\right)}
\deqn{=zg_{1}\left( t\right) +\left( 1-z\right) g_{2}\left( t\right),}

\deqn{F\left( x;\boldsymbol{\theta }\right) =P\left( X\leq x\right) =1-
\left( 1+zx^{\alpha }
\right)
\exp \left( -\beta x^{\alpha }\right),}
and quantile function is given by
\deqn{Q\left( u;\boldsymbol{\theta }\right) =F^{-1}\left( u;
\boldsymbol{\theta }\right) =\left\{ -\frac{W\left( \left(
1+\beta \right) \left( -1+u\right) \exp \left( -\left( 1+\beta \right)
                                              \right) \right) +1+\beta }
                                     {\beta }\right\} ^{\frac{1}{\alpha }},}
where
\deqn{z =\frac{\beta }{\beta +1},}
\deqn{g_{1}\left( x\right)  =\alpha \beta x^{\alpha -1}\exp \left( -\beta
x^{\alpha }\right),}
\deqn{g_{2}\left( x\right)  =\alpha \beta ^{2}x^{2\alpha -1}\exp \left(-\beta
x^{\alpha }\right),}
\eqn{\boldsymbol{\theta =}\left( \alpha ,\beta \right) }, \eqn{0<u<1},
\eqn{\alpha>0} is a shape parameter, \eqn{\beta>0} is a scale parameter and
W(•) is Lambert W function.

Additionally, the estimation methods Anderson-Darling "AD", Cramér-von Mises
"CvM", least squares "LS" and weighted least squares "WLS" as well as the
"TRUE" option for the true value, are available. Please note that the default
value for the method parameter is maximum likelihood "ML" estimation.

The cut-off point values corresponding to Youden's J index (J), the criterion
closest to (0, 1) (ER), the concordance probability method (CZ), and the newly
proposed Ertan-Coskun index (EC) are provided.
}
\examples{
dPLD(c(1,2,3,4,5,200),alpha=3,beta=2)
pPLD(c(.5,1,2,3,4),alpha=3,beta=2)
qPLD(c(.9971,0.5,0.3),alpha=3,beta=2)
rPLD(10,alpha=3,beta=2)
r.pl_auc(x=c(1,2,2,3,1),y=c(1,3,2,4,2,3),
true_param=c(alpha1=1,beta1=1,alpha2=1,beta2=1),method=c("TRUE"))
r.pl_index(x=c(1,2,2,3,1),y=c(1,3,2,4,2,3),init_param=c(1,1,1,1),
init_index=1,method=c("MLE"))
\donttest{x=c(1,2,2,3,1)}
\donttest{y=c(1,3,2,4,2,3)}
\donttest{r.pl_graph(x,y,init_param=c(1,1,1,1),
empirical=TRUE,method=c("MLE"))}
}
\references{
Akgenç, E., and Kuş, C., 2023,
\emph{ROC Curve Analysis for the Measurements Distributed Power-Lindley}
\emph{Distribution},
2nd International E-Conference On Mathematical And Statistical Sciences:
A Selçuk Meeting (ICOMSS-2023), Konya, 25.

Attwood, K., Hou, S., and Hutson, A., 2022,
\emph{Application of the skew exponential power distribution to ROC curves},
Journal of Applied Statistics, 1-16.

Ghitany M., Al-Mutairi D. K., Balakrishnan N., and Al-Enezi L., 2013,
\emph{Power lindley distribution and associated inference},
Computational Statistics & Data Analysis, 64,20–33.

Liu, X., 2012,
\emph{Classification accuracy and cut point selection},
Statistics in medicine, 31(23), 2676-2686.

Nahm, F. S., 2022,
\emph{Receiver operating characteristic curve: overview and practical use for}
\emph{clinicians},
Korean journal of anesthesiology, 75(1), 25-36.

Perkins, N. J., and Schisterman, E. F., 2006,
\emph{The inconsistency of “optimal” cutpoints obtained using two}
\emph{criteria based on the receiver operating characteristic curve},
American journal of epidemiology, 163(7), 670-675.

Pundir, S. and Amala, R., 2014,
\emph{Evaluation of area under the constant shape bi-weibull roc curve},
Journal of Modern Applied Statistical Methods, 13(1),1-20.

Youden, W. J., 1950,
\emph{Index for rating diagnostic tests}, Cancer, 3(1), 32-35.
}
