% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMEvapotranspiration.R
\name{calculateET0}
\alias{calculateET0}
\title{PMEvapotranspiration}
\usage{
calculateET0(T_max, T_min, Latitude, altitude, RH_min, RH_max, u2, n, J)
}
\arguments{
\item{T_max}{Maximum temperature in degree Celsius}

\item{T_min}{Minimum temperature in degree Celsius}

\item{Latitude}{Latitude in decimal degree}

\item{altitude}{altitude in meter}

\item{RH_min}{Minimum Relative humidity in percentage}

\item{RH_max}{Maximum Relative humidity in percentage}

\item{u2}{The average wind speed (m/s) measured at 2 m above the ground level}

\item{n}{Actual daily sunshine duration}

\item{J}{number of the day in the year between 1 (1 January) and 365 or 366 (31 December)}
}
\value{
Returns a list containing the calculated reference evapotranspiration (ET0) and other intermediate
values used in the calculation. The list includes:
\itemize{
  \item \code{ET0}: Reference evapotranspiration calculated using FAO-56 Penman-Monteith Equation.
  \item \code{T_mean}: Mean temperature.
  \item \code{P}: Atmospheric pressure.
  \item \code{gamma}: Psychrometric constant.
  \item \code{delta}: Slope of vapor pressure curve.
  \item \code{e_s}: Saturation vapor pressure.
  \item \code{e_a}: Actual vapor pressure.
  \item \code{Ra}: Extraterrestrial radiation.
  \item \code{Rso}: Clear sky solar radiation.
  \item \code{Rs}: Solar radiation.
  \item \code{Rns}: Net shortwave radiation.
  \item \code{Rnl}: Net longwave radiation.
  \item \code{Rn}: Net radiation.
}
}
\description{
FAO-56 Penman-Monteith evapotranspiration
}
\examples{
{
calculateET0(T_max = 25, T_min = 15, Latitude = 45,
 altitude = 100, RH_min = 20,
 RH_max = 80, u2 = 2, n = 10, J = 150)
}
}
\references{
#' \itemize{
\item Córdova, M., Carrillo-Rojas, G., Crespo, P., Wilcox, B., and Célleri, R. (2015). Evaluation of the Penman-Monteith (FAO 56 PM) method for calculating reference evapotranspiration using limited data. Mountain Research and Development, 35(3), 230-239.
\item Debnath, S., Adamala, S., and Raghuwanshi, N. S. (2015). Sensitivity analysis of FAO-56 Penman-Monteith method for different agro-ecological regions of India. Environmental Processes, 2, 689-704.
}
}
