% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSAgraphics-package.R
\docType{data}
\name{lindner}
\alias{lindner}
\title{Data on 996 initial Percutaneous Coronary Interventions (PCIs) performed in
1997 at the Lindner Center, Christ Hospital, Cincinnati.}
\format{
A data frame with 996 observations on the following 10 variables, no NAs.
\describe{
\item{lifepres}{Mean life years preserved due to survival for at least 6 months following PCI; numeric value of either 11.4 or 0.}
\item{cardbill}{Cardiac related costs incurred within 6
months of patient's initial PCI; numeric value in 1998 dollars; costs were
truncated by death for the 26 patients with lifepres == 0.}
\item{abcix}{Numeric treatment selection indicator; 0 implies usual
PCI care alone; 1 implies usual PCI care deliberately augmented by either
planned or rescue treatment with abciximab.}
\item{stent}{Coronary
stent deployment; numeric, with 1 meaning YES and 0 meaning NO.}
\item{height}{Height in centimeters; numeric integer from 108 to
196.}
\item{female}{Female gender; numeric, with 1 meaning YES and 0
meaning NO.}
 \item{diabetic}{Diabetes mellitus diagnosis; numeric,
with 1 meaning YES and 0 meaning NO.}
\item{acutemi}{Acute
myocardial infarction within the previous 7 days; numeric, with 1 meaning
YES and 0 meaning NO.}
\item{ejecfrac}{Left ejection fraction;
numeric value from 0 percent to 90 percent.}
\item{ves1proc}{Number
of vessels involved in the patient's initial PCI procedure; numeric integer
from 0 to 5.}
}

A data frame with 996 observations on the following 10 variables, no
NAs. \describe{ \item{list("lifepres")}{Mean life years preserved due to
survival for at least 6 months following PCI; numeric value of either 11.4
or 0.} \item{list("cardbill")}{Cardiac related costs incurred within 6
months of patient's initial PCI; numeric value in 1998 dollars; costs were
truncated by death for the 26 patients with lifepres == 0.}
\item{list("abcix")}{Numeric treatment selection indicator; 0 implies usual
PCI care alone; 1 implies usual PCI care deliberately augmented by either
planned or rescue treatment with abciximab.} \item{list("stent")}{Coronary
stent deployment; numeric, with 1 meaning YES and 0 meaning NO.}
\item{list("height")}{Height in centimeters; numeric integer from 108 to
196.} \item{list("female")}{Female gender; numeric, with 1 meaning YES and 0
meaning NO.} \item{list("diabetic")}{Diabetes mellitus diagnosis; numeric,
with 1 meaning YES and 0 meaning NO.} \item{list("acutemi")}{Acute
myocardial infarction within the previous 7 days; numeric, with 1 meaning
YES and 0 meaning NO.} \item{list("ejecfrac")}{Left ejection fraction;
numeric value from 0 percent to 90 percent.} \item{list("ves1proc")}{Number
of vessels involved in the patient's initial PCI procedure; numeric integer
from 0 to 5.} }
}
\source{
Package USPS, by R. L. Obenchain.

Package USPS, by R. L. Obenchain.
}
\description{
Data from an observational study of 996 patients receiving a PCI at Ohio
Heart Health in 1997 and followed for at least 6 months by the staff of the
Lindner Center. This is a landmark dataset in the literature on propensity
score adjustment for treatment selection bias due to practice of evidence
based medicine; patients receiving abciximab tended to be more severely
diseased than those who did not receive a IIb/IIIa cascade blocker.

Data from an observational study of 996 patients receiving a PCI at Ohio
Heart Health in 1997 and followed for at least 6 months by the staff of the
Lindner Center. This is a landmark dataset in the literature on propensity
score adjustment for treatment selection bias due to practice of evidence
based medicine; patients receiving abciximab tended to be more severely
diseased than those who did not receive a IIb/IIIa cascade blocker.
}
\keyword{datasets}
