% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpc.R
\name{rpc}
\alias{rpc}
\title{Plasticizing Component}
\usage{
rpc(n, teta, s2, c)
}
\arguments{
\item{n}{positive number of observations}

\item{teta}{position parameter}

\item{s2}{positive scale parameter}

\item{c}{shape parameter (c>=1)}
}
\value{
The function returns random generator values for the plasticizing component.
}
\description{
Density, distribution function, quantile function and random generation
for the plasticizing component with parameters teta, s2 and c.
}
\details{
Probability density function
see formula (2) in the article
Cumulative distribution function
see formula (4)
Quantile functon
see formula (9)
Random number generator
see formula (23)
}
\examples{
dpc(0,1,2,2)
ppc(0,1,2,2)
qpc(0.5,1,2,2)
rpc(10,1,2,2)

}
\references{
{Sulewski, P. (2020). \emph{Normal Distribution with Plasticizing Component,} Communications in Statistics ? Theory and Method 51(11), 3806-3835.}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@upsl.edu.pl}, Pomeranian UNiwersity in Slupsk.
}
