% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod2.stat.R
\name{Mod2.stat}
\alias{Mod2.stat}
\title{Modular test for independence in two-way contingency table}
\usage{
Mod2.stat(nij)
}
\arguments{
\item{nij}{a numeric matrix with non-negative values of the two-way contingency table cells}
}
\value{
The function returns the value of the modular test statistic.
}
\description{
Calculates the statistic of the modular test for independence in two-way contingency table
(see Sulewski P. (2016)).
}
\details{
The statistic of the modular test for independence in r x c contingency table,
see formula (2) in the article.
}
\examples{
tab5=GenTab2(matrix(1/12, nrow = 3, ncol = 4), 60)
Mod2.stat(tab5)
Mod2.stat(table1)

}
\references{
{Sulewski, P. (2016). \emph{Moc testów niezależności w tablicy dwudzielczej większej niż 2×2,} Przegląd statystyczny 63(2), 190-210}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
