% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pssm_sd.R
\name{PSSM_SD}
\alias{PSSM_SD}
\title{PSSM-SD feature}
\usage{
PSSM_SD(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 80
}
\description{
In this feature, by considering a specific column, at first sum of all components in this column
is denoted by "L", then starting from the first row in this column, the components are added together to
reaching a value less than or equal to 25% of L, and the number of components to get such a sum in this column
is calculated and stored . In the next step, the same work is done starting from the first row to reaching a
value less than or equal to 50% of L, and the number of components is saved. In the next step, the same work
is done started from the last row, To reaching 25% and 50% of L, and number of components is saved as before.
By appending these saved numbers together for each column, a vector of length 4 is obtained. If this is done
for all the columns and the obtained vectors are connected to each other, for each protein, a feature vector
of length 80 is obtained which its name is PSSM-SD.
}
\examples{
X<-PSSM_SD(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
A. Dehzangi, K. Paliwal, J. Lyons, A. Sharma, A. J. I. A. T. o. C. B. Sattar, and Bioinformatics,
"A segmentation-based method to extract structural and evolutionary features for protein fold
recognition," vol. 11, no. 3, pp. 510-519, 2014.
}
