% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_sequence.R
\name{strip_sequence_DIANN}
\alias{strip_sequence_DIANN}
\title{Strip sequence from DIANN outputs}
\usage{
strip_sequence_DIANN(data, column, convert_column)
}
\arguments{
\item{data}{A dataframe with a column containing peptide sequences to be stripped}

\item{column}{The name of the column containing the peptide sequences to be stripped.}

\item{convert_column}{The name of the column where the stripped sequences will be stored.}
}
\value{
A dataframe with a column containing stripped sequence
}
\description{
This function takes DIANN output containing a column with peptide sequences to be stripped
and converts it into a new dataframe with the stripped sequence
}
\examples{
library(data.table)
data <- data.table(
  Modified.Sequence = c(
    "AAAAGPGAALS(UniMod:21)PRPC(UniMod:4)DSDPATPGAQSPK",
    "AAAASAAEAGIATTGTEDSDDALLK",
    "AAAAALSGSPPQTEKPT(UniMod:21)HYR"
  ),
  Condition = c("A", "B", "B")
)
column <- 'Modified.Sequence'
convert_column <- 'Sequence'
converted_data <- strip_sequence_DIANN(data, column, convert_column)

}
