% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPODBAYEfficacy.R
\name{efficacyComputation}
\alias{efficacyComputation}
\title{PoDBAY efficacy equation}
\usage{
efficacyComputation(PoDParameters, 
                    means = NA, 
                    standardDeviations = NA,
                    adjustTiters = FALSE,
                    adjustFrom = NA,
                    adjustTo = NA)
}
\arguments{
\item{PoDParameters}{named data frame ("pmax", "slope", "et50"): PoD curve parameters}

\item{means}{named list ("vaccinated", "control"): mean values of vaccinated and control subjects titers}

\item{standardDeviations}{named list ("vaccinated", "control"): standard deviations of vaccinated and control subjects titers}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
efficacy: numeric value
}
\description{
Function calculates the PoDBAY efficacy based on the PoD curve parameters and titer distribution parameters (mean, sd) for vaccinated and control groups.
}
\details{
\deqn{Efficacy = 1 - \frac{E[PoD_{vaccinated}]}{{E[PoD_{control}]} } }{ Efficacy = 1 - E[PoD|vaccinated]/ E[PoD|control]}.

E[PoD] for each group is calculated as integral from -Inf to Inf of (titer density function) * (PoD Curve); for further details see Example2 and\code{ExpectedPoD} function.
}
\examples{
## Data preparation
data(vaccinated)
data(control)
data(PoDParams)

## Example 1
means <- list(vaccinated = vaccinated$mean, control = control$mean)

standardDeviations <- list(vaccinated = vaccinated$stdDev, control = control$stdDev)

efficacyComputation(PoDParams, means, standardDeviations)


}
