% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pop.R
\name{summary.pop}
\alias{summary.pop}
\title{Generate descriptive summary for objects returned by other functions in PoPdesign}
\usage{
\method{summary}{pop}(object, ...)
}
\arguments{
\item{object}{the object returned by other functions.}

\item{...}{ignored arguments}
}
\value{
\code{summary()} prints the objects returned by other functions.
}
\description{
Generate descriptive summary for objects returned by other functions.
}
\examples{
## summarize the results returned by get.boundary.pop()
bound <- get.boundary.pop(n = 15, cohortsize = 3, target=0.3,
                          cutoff=exp(1), K=3,cutoff_e=exp(-1))
summary(bound)

## summarize the results returned by get.oc.pop()
oc <- get.oc.pop(target=0.3,n=15,cohortsize=3,titration=TRUE,
                 cutoff=TRUE,cutoff_e=exp(-1),skeleton=c(0.3,0.4,0.5,0.6),n.trial=1000,
                 risk.cutoff=0.8,earlyterm=TRUE,start=1)
summary(oc)

### summarize the results returned by select.mtd.pop()
n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)
selmtd <- select.mtd.pop(target=0.3,n.pts=n, n.tox=y)
summary(selmtd)

}
