% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMultiEntryPerturbationExpectation.R
\name{ComputeMultiEntryPerturbationExpectation}
\alias{ComputeMultiEntryPerturbationExpectation}
\title{Compute Multi Entry Perturbation Expectation}
\usage{
ComputeMultiEntryPerturbationExpectation(
  input_file,
  num_iterates = 1000,
  interval_length = 0.01,
  threads = 1
)
}
\arguments{
\item{input_file}{Input comma separated file for the jacobian matrix.}

\item{num_iterates}{Number of iterates in the Monte Carlo sampling to perform.
Default: 10000}

\item{interval_length}{Interval length over which to make the perturbations.
Default: 0.01}

\item{threads}{Number of threads to use. Default: 1}
}
\value{
returns a scalar
}
\description{
This function takes a jacobian matrix and computes the multi-entry 
perturbation expectation.
}
\examples{
\dontrun{
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt") 
ComputeMultiEntryPerturbationExpectation(input_file = infile)
}
}
