% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{OptPx}
\alias{OptPx}
\title{\code{OptPx} object constructor}
\usage{
OptPx(o = Opt(), r = 0.05, q = 0, rf = 0, vol = 0.3, NSteps = 3)
}
\arguments{
\item{o}{An object of class \code{Opt}}

\item{r}{A risk free rate (annualized)}

\item{q}{A dividend yield (as annualized rate), Hull/p291}

\item{rf}{A foreign risk free rate (annualized), Hull/p.292}

\item{vol}{A volaility (as Sd.Dev, sigma)}

\item{NSteps}{A number of time steps in BOPM calculation}
}
\value{
A list of class \code{OptPx} with parameters supplied to \code{Opt} and \code{OptPx} constructors
}
\description{
An S3 object constructor for lattice-pricing specifications for an option contract. \code{Opt} object is inhereted.
}
\examples{
OptPx()  #Creates an S3 object for an option contract

#See J.C.Hull, OFOD'2014, 9-ed, Fig.13.10, p.289
OptPx(Opt(Right='Put'))

o = OptPx(Opt(Right='Call', S0=42, ttm=.5, K=40), r=.1, vol=.2)
}
\author{
Oleg Melnikov, Department of Statistics, Rice University, Spring 2015
}

