% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QMontyHall.R
\name{QMontyHall}
\alias{QMontyHall}
\title{Quantum Monty Hall Problem}
\usage{
QMontyHall(Psi_in, gamma, Ahat, Bhat)
}
\arguments{
\item{Psi_in}{a vector representing the initial quantum state}

\item{gamma}{a number between 0 and pi/2 including the end points}

\item{Ahat}{a matrix lying in SU(3)}

\item{Bhat}{a matrix lying in SU(3)}
}
\value{
A vector consisting of the expected payoffs to Alice and Bob as its elements depending on the input parameters.
}
\description{
This function simulates the quantum version of the Monty Hall problem, by taking in \code{Psi_in} as the initial quantum state of the game, \code{gamma} lying in 0 to pi/2, \code{Ahat} and \code{Bhat} as the choice operators in SU(3) for Alice and Bob respectively as the inputs. It returns the expected payoffs to Alice and Bob after the end of the game.
}
\examples{
init()
Psi_in <- kronecker(Q$Qt0, (Q$Qt00+Q$Qt11+Q$Qt22)/sqrt(3))
QMontyHall(Psi_in, pi/4, Q$Identity3, Q$Hhat)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0109035.pdf}\cr
}
