% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dabcd_max_power.r
\name{dabcd_max_power}
\alias{dabcd_max_power}
\title{Allocation Probabilities Using Doubly Adaptive Biased Coin Design with Maximal Power Strategy for Binary Endpoint}
\usage{
dabcd_max_power(NN, Ntotal1, armn, BB, type, dabcd = FALSE, gamma = 2)
}
\arguments{
\item{NN}{a vector representing the number of participants with success results for each arm
estimated from the current data.}

\item{Ntotal1}{a vector representing the total number of participants for each arm
estimated from the current data.}

\item{armn}{number of total arms in the trial.}

\item{BB}{the minimal allocation probability for each arm, which is within the
range of \eqn{[0,1/armn]}.}

\item{type}{allocation type, with choices from 'RSIHR' and 'Neyman'.}

\item{dabcd}{an indicator of whether to apply Hu & Zhang's formula (\insertCite{Hu2004}{RARtrials}), with choices from FALSE and TRUE.
TRUE represents allocation probabilities calculated using Hu & Zhang's formula;
FALSE represents allocation probabilities calculated before applying Hu & Zhang's formula.
Default value is set to FALSE.}

\item{gamma}{tuning parameter in Hu & Zhang's formula (\insertCite{Hu2004}{RARtrials}). When \code{dabcd}=FALSE, this parameter does not need
to be specified. Default value is set to 2.}
}
\value{
A vector of allocation probabilities to each arm.
}
\description{
\code{dabcd_max_power} can be used for doubly adaptive biased coin design with maximal power
strategy for binary outcomes, targeting generalized Neyman allocation and generalized RSIHR allocation. The return 
of this function is a vector of allocation probabilities to each arm, with the pre-specified number of participants in the trial.
}
\details{
The function simulates allocation probabilities for doubly adaptive biased coin design with maximal power strategy targeting
generalized Neyman allocation with 2-5 arms which is provided in \insertCite{Tymofyeyev2007}{RARtrials} or
generalized RSIHR allocation with 2-3 arms which is provided in \insertCite{Jeon2010}{RARtrials}, with modifications for typos
in \insertCite{Sabo2016}{RARtrials}. All of those methods are not smoothed. The output of this function is based on Hu \code{\&} Zhang's formula \insertCite{Hu2004}{RARtrials}.
With more than two armd the one-sided nominal level of each test is \code{alphaa} divided by \code{arm*(arm-1)/2}; a Bonferroni correction.
}
\examples{
dabcd_max_power(NN=c(54,67,85,63,70),Ntotal1=c(100,88,90,94,102),armn=5,BB=0.2, type='Neyman')
dabcd_max_power(NN=c(54,67,85,63),Ntotal1=c(100,88,90,94),armn=4,BB=0.2, type='Neyman')
}
\references{
\insertRef{Hu2004}{RARtrials}

\insertRef{Tymofyeyev2007}{RARtrials}

\insertRef{Jeon2010}{RARtrials}

\insertRef{Sabo2016}{RARtrials}
}
\author{
Chuyao Xu, Thomas Lumley, Alain Vandal
}
