% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RD_bme.R
\name{RDHonestBME}
\alias{RDHonestBME}
\title{Honest CIs in sharp RD with discrete regressors under BME function class}
\usage{
RDHonestBME(
  formula,
  data,
  subset,
  cutoff = 0,
  na.action,
  h = Inf,
  alpha = 0.05,
  order = 0,
  regformula
)
}
\arguments{
\item{formula}{object of class \code{"formula"} (or one that can be coerced
to that class) of the form \code{outcome ~ running_variable}}

\item{data}{optional data frame, list or environment (or object coercible by
\code{as.data.frame} to a data frame) containing the outcome and running
variables in the model. If not found in \code{data}, the variables are
taken from \code{environment(formula)}, typically the environment from
which the function is called.}

\item{subset}{optional vector specifying a subset of observations to be used
in the fitting process.}

\item{cutoff}{specifies the RD cutoff in the running variable.}

\item{na.action}{function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{options} (usually \code{na.omit}). Another possible value is
\code{na.fail}}

\item{h}{bandwidth, a scalar parameter.}

\item{alpha}{determines confidence level, \eqn{1-\alpha}{1-alpha}}

\item{order}{Order of local regression \code{1} for linear, \code{2} for
quadratic, etc.}

\item{regformula}{Explicitly specify regression formula to use instead of
running a local polynomial regression, with \code{y} and \code{x}
denoting the outcome and the running variable, and cutoff is normalized
to \code{0}. Local linear regression (\code{order = 1}) is equivalent to
\code{regformula = "y~x*I(x>0)"}. Inference is done on the
\code{order+2}th element of the design matrix}
}
\value{
An object of class \code{"RDResults"}. This is a list with at least
    the following elements:

   \describe{

   \item{\code{"coefficients"}}{Data frame containing estimation results,
   including point estimate, one- and two-sided confidence intervals, a bound
   on worst-case bias, bandwidth used, and the number of effective
   observations.}

   \item{\code{"call"}}{The matched call.}

   \item{\code{"lm"}}{An \code{"lm"} object containing the fitted
   regression.}

   \item{\code{"na.action"}}{(If relevant) information on the special
   handling of \code{NA}s.}

}
}
\description{
Computes honest CIs for local polynomial regression with uniform kernel in
sharp RD under the assumption that the conditional mean lies in the bounded
misspecification error (BME) class of functions, as considered in Kolesár and
Rothe (2018). This class formalizes the notion that the fit of the chosen
model is no worse at the cutoff than elsewhere in the estimation window.
}
\section{Note}{

\code{subset} is evaluated in the same way as variables in \code{formula},
that is first in \code{data} and then in the environment of \code{formula}.
}

\examples{
RDHonestBME(log(earnings)~yearat14, data=cghs, h=3,
            order=1, cutoff=1947)
## Equivalent to
RDHonestBME(log(earnings)~yearat14, data=cghs, h=3,
            cutoff=1947, order=1, regformula="y~x*I(x>=0)")
}
\references{
{

\cite{Michal Kolesár and Christoph Rothe. Inference in regression
      discontinuity designs with a discrete running variable. American
      Economic Review, 108(8):2277—-2304, August 2018.
      \doi{10.1257/aer.20160945}}

}
}
