% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{redi}
\alias{redi}
\title{Compute REDI for all observed and missing input values in a dataset}
\usage{
redi(
  data,
  coef = c(0.05, 0.1, 0.5),
  input = 1,
  output = 2,
  plot = TRUE,
  by = "day",
  format = "\%Y\%m\%d",
  summary_duplicate = mean
)
}
\arguments{
\item{data}{A tibble or a data frame, containing an \code{Input} column that is
used as reference for the observations (e.g. time for
longitudinal data), and an \code{Output} column specifying the observed
values of interest (the workload).}

\item{coef}{A number or vector, containing the values of the lambda
coefficient used in the REDI computations, controlling the decay
of the exponential weights. Default is c(0.05, 0.1, 0.5).}

\item{input}{A character or a number, indicating the name or the
index of the \code{Input} column (time).}

\item{output}{A character or a number, indicating the name or the
index of the \code{Output} column (workload).}

\item{plot}{A boolean, indicating whether results should be displayed.
is TRUE.}

\item{by}{A number or a character string, indicating the reference time
period between two observations. Possible values are 'day', 'week',
'month', 'year', or any arbitrary number. See documentation of the 'seq()'
for additional information if necessary. Default is 'day'.}

\item{format}{A character string, indicating the date format of the input.
Please read \code{lubridate::as_date()}. Default is '\%Y\%m\%d'.}

\item{summary_duplicate}{A function, used to summarise Output values for
duplicated Input values. Default is mean.}
}
\value{
A tibble containing 4 columns : \code{Input} (without duplicates),
\code{Output}, \code{Lambda} and \code{REDI}, which corresponds to the vector
returned by the \code{loop_REDI()} function.
}
\description{
Wrapper function that converts the dataset to the adequate format, compute
values of REDI for each \code{Input} values, display a generic plot of the results
and return a tibble containing both data and corresponding REDI values.
}
\examples{
data <- simu_db()
redi <- redi(data)
}
