% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPPlabAgg.R
\name{EPPlabAgg}
\alias{EPPlabAgg}
\title{Function to Aggregate Directions From epplab Objects}
\usage{
EPPlabAgg(x, method = "cumulative", percentage = 0.85)
}
\arguments{
\item{x}{An object of class \code{epplab} or a list of \code{epplab} objects.}

\item{method}{The type of method, see details. Options are \code{inverse}, \code{sq.inverse} and \code{cumulative}.}

\item{percentage}{Threshold for the relative eigenvalue sum to retain, see details.}
}
\value{
A list with class 'epplabagg' containing the following components:
\item{P}{The estimated average orthogonal projection matrix.}
\item{O}{An orthogonal matrix on which P is based upon.}
\item{k}{The rank of the average orthogonal projection matrix.}
\item{eigenvalues}{The relevant eigenvalues, see details. Only given if \code{method="cumulative"}.}
}
\description{
Function that automatically aggregates the projection directions from one or more \code{epplab} objects.
Three options are available on how to choose the final projection which can have a rank larger than one.
The parameter \code{x} can either be a single object or a list of epplab objects.
Options for \code{method} are \code{inverse}, \code{sq.inverse} and \code{cumulative}.
}
\details{
Denote \eqn{p_i, i=1,...,m}, the projection vectors contained in the list of \code{epplab} objects 
and \eqn{P_i, i=1,..,m}, the corresponding orthogonal projection matrices (each having rank one). 
The method \code{cumulative} is based on the eigenvalue decomposition of 
  \eqn{P_w=\frac 1m \sum_{i=1}^m P_i}{P_w=1/m sum(P_i)}
 and transforms as \code{O} the eigenvectors such that the corresponding
 relative eigenvalues sum is at least \code{percentage}.
 The number of eigenvectors retained corresponds to the rank \code{k} and
 \code{P} is the corresponding orthogonal projection matrix.
 The methods \code{inverse} and \code{sq.inverse} are automatic rules to
 choose the number of eigenvectors to retain as implemented by the function
 \code{\link[LDRTools]{AOP}}.
}
\examples{

 library(tourr)
 data(olive)
 # To keep the runtime short, maxiter and n.simu were chosen very 
 # small for demonstration purposes, real life applications would
 # rather choose larger values, e.g. n.simu=100, maxiter=200
 olivePP.kurt.max <-
   EPPlab(olive[,3:10],PPalg="PSO",PPindex="KurtosisMax",n.simu=10, maxiter=20)
 
 olivePP.fried <-
   EPPlab(olive[,3:10],PPalg="PSO",PPindex="Friedman",n.simu=10, maxiter=20)
 
 olivePPs <- list(olivePP.kurt.max, olivePP.fried)
 
 EPPlabAgg(olivePP.kurt.max)$k
 EPPlabAgg(olivePPs, "cum", 0.99)$k
 
 pairs(olivePP.kurt.max$x \%*\% EPPlabAgg(olivePPs, "cum", 0.99)$O,
       col=olive[,2], pch=olive[,1])
 
 
 olivAOP.sq <- EPPlabAgg(olivePPs, "inv")
 oliveProj <- olivePP.kurt.max$x \%*\% olivAOP.sq$O
 plot(density(oliveProj))
 rug(oliveProj[olive$region==1],col=1)
 rug(oliveProj[olive$region==2],col=2)
 rug(oliveProj[olive$region==3],col=3)

}
\references{
\cite{Liski, E., Nordhausen, K., Oja, H. and Ruiz-Gazen, A. (201?), Combining Linear Dimension Reduction Estimates, to appear in the Proceedings of \emph{ICORS 2015}, pp. ??-??.}
}
\seealso{
\code{\link{EPPlab}}, \code{\link[LDRTools]{AOP}}
}
\author{
Daniel Fischer, Klaus Nordhausen, Anne Ruiz-Gazen
}
\keyword{multivariate}
