% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.epplab.R
\docType{methods}
\name{coef.epplab}
\alias{coef.epplab}
\alias{coef-method}
\alias{coef,epplab-method}
\title{Extracts the Directions of an Epplab Object}
\usage{
\method{coef}{epplab}(object, which = 1:ncol(object$PPdir), ...)
}
\arguments{
\item{object}{Object of class \code{epplab}.}

\item{which}{Specifies which directions are extracted.}

\item{...}{Additional parameters.}
}
\description{
Extracts the found directions of an \code{epplab} object.
}
\details{
The coef function extracts the directions found from the EPPlab call.
}
\examples{

library(tourr)
data(olive)
res <- EPPlab(olive[,3:10],PPalg="PSO",PPindex="KurtosisMin",n.simu=10, maxiter=20)
coef(res)

}
\author{
Daniel Fischer
}
\keyword{methods}
\keyword{print}
