% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_steps.R
\name{.gibbsStep2Eq}
\alias{.gibbsStep2Eq}
\title{Draws from the posterior of the parameters of the cubs equation, conditional on the states.}
\usage{
.gibbsStep2Eq(
  Y,
  X,
  p,
  pk,
  pa,
  betaLast,
  sigmaLast,
  betaDistr,
  sigmaDistr,
  phiLast = NULL,
  phiDistr = NULL,
  phiC,
  sigmaC
)
}
\arguments{
\item{Y}{a \code{Tn x 1} vector.}

\item{X}{a \code{Tn x n} matrix, includes a constant, the contemporaneous cycle, cycle
lags, and lags of cubs.}

\item{p}{integer, lag of cubs.}

\item{pk}{integer, contemporaneous cycle and cycle lags.}

\item{pa}{integer, autoregressive order of error term.}

\item{betaLast}{last draw from posterior of beta.}

\item{sigmaLast}{last draw from posterior of cubs innovation variance.}

\item{betaDistr}{prior distribution of beta.}

\item{sigmaDistr}{prior distribution of cubs innovation variance.}

\item{phiLast}{(optional) vector, last draw from posterior of the autoregressive
parameter of the error term.}

\item{phiDistr}{(optional) prior of the autoregressive parameter of the error term.}

\item{phiC}{parameter vector of the cycle equation.}

\item{sigmaC}{innovation variance of the cycle equation}
}
\description{
Draws from the posterior of the parameters of the cubs equation, conditional on the states.
}
\details{
The parameter vector beta and the innovation variance are Normal-inverse Gamma
  distributed. A draw from their posterior is obtained by conjugacy.

If there are additional lags of the cycle or cubs, conjugacy does not apply
  since the starting values are not given. In this case, a Metropolis-Hasting step is
  implemented.

If the error term is an AR(1) or AR(2) process, an additional Gibbs step draws
  from the posterior of the autoregressive parameter, given all other parameters.
}
\keyword{internal}
