% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRITIC.R
\name{apply.CRITIC}
\alias{apply.CRITIC}
\title{Apply CRITIC on comparison matrix}
\usage{
apply.CRITIC(A)
}
\arguments{
\item{A}{the matrix A with row names corresponding to alternatives and column
names corresponding to criteria}
}
\value{
the weight percentages related to matrix A obtained through the CRITIC method
}
\description{
Apply CRITIC on comparison matrix
}
\examples{
A <- matrix(c(250, 200, 300, 275,
 225, 16, 16, 32,
  32, 16, 12, 8,
   16, 8, 16, 5,
    3, 4, 4, 2), nrow=5, ncol=4)
colnames(A)<-c("Price", "Storage space", "Camera", "Looks")
rownames(A)<-paste0("Mobile ", seq(1, 5, 1))
A[,"Price"] <- -A[,"Price"]
apply.CRITIC(A)
}
