% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soft_impute_tune.R
\name{soft_impute_tune}
\alias{soft_impute_tune}
\title{Matrix completion via nuclear-norm regularization with hyperparameter tuning}
\usage{
soft_impute_tune(
  X,
  lambda = fraction_grid(reverse = TRUE),
  relative = TRUE,
  splits = holdout_control(),
  ...,
  discretize = TRUE,
  values = NULL
)
}
\arguments{
\item{X}{a matrix or data frame with missing values.}

\item{lambda}{a numeric vector giving values of the regularization 
parameter.  See \code{\link{fraction_grid}()} for the default values.}

\item{relative}{a logical indicating whether the values of the 
regularization parameter should be considered relative to a certain 
reference value computed from the data at hand.  If \code{TRUE} (the 
default), the values of \code{lambda} are multiplied with the value 
returned by \code{\link[softImpute]{lambda0}()} (applied to the 
mean-centered data matrix).}

\item{splits}{an object inheriting from class \code{"split_control"}, as 
generated by \code{\link{holdout_control}()} for repeated holdout validation 
or \code{\link{cv_folds_control}()} for \eqn{K}-fold cross-validation, or a 
list of index vectors giving different validation sets of observed cells as 
generated by \code{\link{create_splits}()}.  Cells in the validation set
will be set to \code{NA} for fitting the algorithm with the training set of 
observed cells.}

\item{\dots}{additional arguments to be passed down to 
\code{\link{soft_impute}()}.}

\item{discretize}{a logical indicating whether to include a discretization 
step after fitting the algorithm (defaults to \code{TRUE}).  In case of 
discrete rating-scale data, this can be used to map the imputed values to 
the discrete rating scale of the observed values.}

\item{values}{an optional numeric vector giving the possible values of 
discrete ratings.  This is ignored if \code{discretize} is \code{FALSE}.  
Currently, the possible values are assumed to be the same for all columns.  
If \code{NULL}, the unique values of the observed parts of \code{X} are 
used.}
}
\value{
An object of class \code{"soft_impute_tuned"} with the following components: 
\item{lambda}{a numeric vector containing the values of the regularization 
parameter.}
\item{tuning_loss}{a numeric vector containing the (average) values of the 
loss function on the validation set(s) for each value of the regularization 
parameter.}
\item{lambda_opt}{numeric; the optimal value of the regularization 
parameter.}
\item{fit}{an object of class \code{"\link{soft_impute}"} containing the 
results from the algorithm with the optimal regularization parameter on the 
full (observed) data matrix.}

The class structure is still experimental and may change in the future. 
The following accessor functions are available:
\itemize{
  \item \code{\link{get_completed}()} to extract the imputed data matrix (with the 
  optimal value of the regularization parameter),
  \item \code{\link{get_lambda}()} to extract the optimal value of the 
  regularization parameter.
}
}
\description{
Perform matrix completion via nuclear-norm regularization based on  
\code{\link[softImpute]{softImpute}()}.  The regularization parameter 
is thereby selected via repeated holdout validation or cross-validation.  
Note that this uses the convenience wrapper \code{\link{soft_impute}()}, 
whose default behavior is different from that of the original function.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# Soft-Impute with discretization step and hyperparameter tuning
set.seed(20250723)
fit <- soft_impute_tune(MovieLensToy, 
                        lambda = fraction_grid(nb_lambda = 6, 
                                               reverse = TRUE),
                        splits = holdout_control(R = 5))
# extract discretized completed matrix with optimal 
# regularization parameter
X_hat <- get_completed(fit)
head(X_hat)
# extract optimal value of regularization parameter
get_lambda(fit)

}
\references{
Hastie, T., Mazumder, R., Lee, J. D. and Zadeh, R. (2015) Matrix Completion 
and Low-Rank SVD via Fast Alternating Least Squares. \emph{Journal of 
Machine Learning Research}, \bold{16}(104), 3367--3402.

Mazumder, R., Hastie, T. and Tibshirani, R. (2010) Spectral Regularization 
Algorithms for Learning Large Incomplete Matrices. \emph{Journal of Machine 
Learning Research}, \bold{11}(80), 2287--2322.
}
\seealso{
\code{\link{soft_impute}()}, \code{\link{fraction_grid}()}, 

\code{\link{holdout_control}()}, \code{\link{cv_folds_control}()}, 
\code{\link{create_splits}()}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
